<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_mb2nl
 * @copyright 2017 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license   PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

global $PAGE, $OUTPUT;

if (theme_mb2nl_is_login(true)) {
    echo $OUTPUT->theme_part('footer_login', ['sidebar' => false]);
} else if (theme_mb2nl_full_screen_module()) {
    echo $OUTPUT->theme_part('footer_fullscreen', ['sidebar' => $vars['sidebar']]);
} else {
    echo $OUTPUT->theme_part('footer_normal', ['sidebar' => $vars['sidebar']]);
}

echo theme_mb2nl_str2js();

// Purge some caches on editing mode.
if ($PAGE->user_is_editing()) {
    theme_cache_purge('courses'); // Cache of course sections.
    theme_cache_purge('sectioncfg'); // Cache of course sections.
}
