<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_mb2nl
 * @copyright 2017 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license   PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$string['accentcolor'] = 'Accent color';
$string['accessibility'] = 'Accessibility';
$string['acsbalticon'] = 'Alternative icon';
$string['acsbcolorbg'] = 'Background color';
$string['acsbcolortext'] = 'Text color';
$string['acsblineheight'] = 'Line height';
$string['acsboptions'] = 'Accessibility options';
$string['acsbplus'] = '{$a->adj}: plus {$a->time}';
$string['acsbprofiles'] = 'Accessibility profiles';
$string['acsbtextsize'] = 'Text size';
$string['acstyle'] = 'Deprecated';
$string['activemodules'] = 'Active modules';
$string['activequizzes'] = 'Active quizzes';
$string['activestudents'] = 'Active students';
$string['activeusers'] = 'Active';
$string['activeuserstime'] = 'User active time (months)';
$string['activitiesresources'] = 'Activities/resources';
$string['additmenus'] = 'Additional menus';
$string['adhd'] = 'ADHD';
$string['adminblockinfo'] = 'Blocks placed in this region will be visible only for admin users.';
$string['allsections'] = 'All sections';
$string['allsettings'] = 'All settings';
$string['allusers'] = 'All';
$string['alreadyenrolled'] = '{$a->students} already enrolled!';
$string['asstyle'] = 'Deprecated';
$string['autologinguestsanypage'] = 'Deprecated';
$string['bcstyle'] = 'Deprecated';
$string['bestseller'] = 'Bestseller';
$string['bgattachment'] = 'Background attachment';
$string['bgcolor'] = 'Background color';
$string['bgimage'] = 'Background image';
$string['bgpos'] = 'Background position';
$string['bgrepeat'] = 'Background repeat';
$string['bgsize'] = 'Background size';
$string['bigblackcursor'] = 'Big black cursor';
$string['bigwhitecursor'] = 'Big white cursor';
$string['bkmarklimit'] = 'You may add up to {$a->limit} bookmarks';
$string['blockstyle'] = 'Block style';
$string['blockstyledesc'] = 'Deprecated';
$string['blockstyleheading'] = 'Blocks';
$string['blogfeaturedmedia'] = 'Featured media';
$string['blogintro'] = 'Intro text';
$string['blogmodify'] = 'Last modified date';
$string['blogmore'] = 'Load more button';
$string['blogpage'] = 'Blog page';
$string['blogplaceholder'] = 'Blog entry placeholder image';
$string['blogsettings'] = 'Blog';
$string['blogsinglepage'] = 'Single post page';
$string['bold'] = 'Bold';
$string['bolder'] = 'Bolder';
$string['bookmarks'] = 'Bookmarks';
$string['bookmarkslimit'] = 'Bookmarks Limit';
$string['border'] = 'Border';
$string['bottom'] = 'Bottom';
$string['btncolor'] = 'Default button color';
$string['btninversecolor'] = 'Inverse button color';
$string['btnprimarycolor'] = 'Primary button color';
$string['btnsecondarycolor'] = 'Secondary button color';
$string['buttonborder'] = 'Button border';
$string['buttonborderrounded'] = 'Button border rounded corners';
$string['buttonbordersharp'] = 'Button border sharp corners';
$string['buttonrounded'] = 'Button rounded corners';
$string['buttonsharp'] = 'Button sharp corners';
$string['buttonstyle'] = 'Button';
$string['bynameondate'] = '<span class="online">Posted on <span>{$a->date}</span></span> <span class="byline">by <span>{$a->name}</span></span>';
$string['c2cols'] = 'Two columns layout';
$string['cachedef_catcolors'] = 'New Learning - categories colors';
$string['cachedef_categories'] = 'New Learning - course categories';
$string['cachedef_category'] = 'New Learning - shared cache for category record';
$string['cachedef_course'] = 'New Learning - shared cache for course record';
$string['cachedef_coursefield'] = 'New Learning - shared cache for course field record';
$string['cachedef_coursefields'] = 'New Learning - course custom fields';
$string['cachedef_courses'] = 'New Learning - courses';
$string['cachedef_coursetags'] = 'New Learning - course tags';
$string['cachedef_dsahboard'] = 'New Learning - shared cache for custom dashboard feature';
$string['cachedef_features'] = 'New Learning - shared cache for theme features';
$string['cachedef_sectioncfg'] = 'New Learning - shared cache for course sections';
$string['cachedef_ufeatures'] = 'New Learning - theme features';
$string['cachedef_userroles'] = 'New Learning - user roles';
$string['capitalize'] = 'Capitalize';
$string['catcolor'] = 'Category color';
$string['catcolors'] = 'Category colors';
$string['catcolors_desc'] = 'Each line consists separated by pipe character (|): category name|color value.<br>For example:<pre>First category|#4535C1
Second category|#219C90
</pre>';
$string['categorydesc'] = 'Category description';
$string['catfilter'] = 'Deprecated';
$string['catname'] = 'Category name';
$string['cbannerstyle'] = 'Course banner';
$string['cbannertitle'] = 'Deprecated';
$string['cbtntext'] = 'Course button text';
$string['ccimgs'] = 'Crop course images';
$string['cdesc'] = 'Course description';
$string['celsel'] = 'Deprecated';
$string['celseldesc'] = 'Deprecated';
$string['celtypo'] = 'Deprecated';
$string['center'] = 'Center';
$string['certificate'] = 'Certificate';
$string['certificatelinks'] = 'Deprecated';
$string['certificatelinksdesc'] = 'Each line consists separated by pipe characters (|) course_ID|certificate_url. For example:<br><pre>2|https://www.accredible.com/000001</pre>';
$string['certificatestr'] = 'Deprecated';
$string['cficons'] = 'Course custom field icons';
$string['cficons_desc'] = 'Each line consists separated by pipe characters (|): custom filed short name|icon name.<br>For example:<pre>length|fa-clock
level|fa-signal
certificate|fa-certificate
</pre>';
$string['cfont'] = 'Custom fonts';
$string['cfontfiles'] = 'Font files';
$string['cfontfilesdesc'] = 'Upload font files in the following formats: woff2, woff, ttf.';
$string['cfontname'] = 'Font name';
$string['changecolors'] = 'Change colors';
$string['checkplugins'] = 'To finish installation/update:';
$string['choosereadme'] = 'Hey, I\'m New Learning';
$string['cinfo'] = 'Course info';
$string['cistyle'] = 'Course style';
$string['cistyled'] = 'Dark';
$string['cistylela'] = 'Light alternative';
$string['classic'] = 'Classic';
$string['clearfilters'] = 'Clear filters';
$string['cloginpage'] = 'Custom login page';
$string['clogolink'] = 'Custom logo link';
$string['clogotext'] = 'Custom alt text for logo image';
$string['cnewbadge'] = 'Show the \'NEW\' badge from the course start date';
$string['color_danger'] = 'Color danger';
$string['color_info'] = 'Color info';
$string['color_success'] = 'Color success';
$string['color_warning'] = 'Color warning';
$string['coloradjustments'] = 'Color adjustments';
$string['colorn'] = 'Color {$a}';
$string['colors'] = 'Colors';
$string['colorscheme'] = 'Color scheme';
$string['colorvisiondeficiency'] = 'Color vision deficiency';
$string['completion-no'] = 'No completion conditions';
$string['configtabtitle'] = 'Settings';
$string['configtitle'] = 'New Learning';
$string['contentadjustments'] = 'Content adjustments';
$string['continuelearning'] = 'Continue learning';
$string['continuereading'] = 'Continue reading';
$string['continuewith'] = 'Continue with {$a}';
$string['contrastdark'] = 'Dark contrast';
$string['contrastlight'] = 'Light contrast';
$string['coursebtn'] = 'Deprecated';
$string['coursecls'] = 'Deprecated';
$string['courseclsdesc'] = 'Deprecated';
$string['coursecustomfields'] = 'Course custom fields';
$string['coursedashboard'] = 'Course dashboard';
$string['coursedate'] = 'Deprecated';
$string['coursegrid'] = 'Grid layout';
$string['coursegridcat'] = 'Deprecated';
$string['coursegridfp'] = 'Deprecated';
$string['courseimg'] = 'Deprecated';
$string['courseintrovideo'] = 'Course introduction video';
$string['coursemanagement'] = 'Course management';
$string['coursemodifieddate'] = 'Course modified date';
$string['coursenav'] = 'Course custom navigation';
$string['coursepage'] = 'Course page';
$string['coursepanel'] = 'Course panel';
$string['coursepanelpos'] = 'Deprecated';
$string['coursepanelposcontent'] = 'Deprecated';
$string['coursepanelpossitemenu'] = 'Deprecated';
$string['courseparticipation'] = 'Course participation';
$string['courseplaceholder'] = 'Course placeholder image';
$string['courseplimg'] = 'Deprecated';
$string['courseprice'] = 'Course price';
$string['coursescls'] = 'Deprecated';
$string['coursesclsdesc'] = 'Deprecated';
$string['coursesettings'] = 'Course';
$string['courseslist'] = 'Course list';
$string['coursestartdate'] = 'Course start date';
$string['coursestarts'] = 'Deprecated';
$string['coursestudentscount'] = 'Enroled students';
$string['coursesupdated'] = '<span class="date-label">Last updated</span> <span class="date">{$a->updatedate}</span>';
$string['courseswitchlayout'] = 'Course list layout switcher';
$string['coursetoc'] = 'Table of contents';
$string['coursetoclimit'] = 'Table of contents display limit';
$string['coursetocnomod'] = 'Disable table of contents on module page';
$string['coursinstructor'] = 'Course instructor';
$string['cpaneldesclimit'] = 'Deprecated';
$string['cpricefree'] = 'Price free';
$string['cpricereverse'] = 'Currency symbol after course price';
$string['crounded'] = 'Rounded corners';
$string['csection'] = 'Custom field section';
$string['cstylefiles'] = 'Custom style files';
$string['cupdatedate'] = 'Course last updated date';
$string['customcss'] = 'Custom css code';
$string['customdshbheading'] = 'Custom dashboard';
$string['customfooter'] = 'Custom footer';
$string['customquicklinkitems'] = 'Custom quick link items';
$string['customquicklinkitemsdesc'] = 'Each line consists separated by pipe characters (|):<br>text::icon name|url::"1" to open link in a new window|language code or comma-separated codes.<br>For example:<pre>Link text::fa-life-ring|http://example.com</pre>';
$string['customsitemenudesc'] = 'Deprecated';
$string['customsitemnuitems'] = 'Deprecated';
$string['cvideo'] = 'Course video';
$string['danger'] = 'Danger';
$string['dark'] = 'Dark';
$string['darkschemeheading'] = 'Dark color scheme';
$string['darktransparentheading'] = 'Dark and transparent header style';
$string['dateformat'] = 'Date format';
$string['daysago'] = '<span class="timeago">{$a} days</span> ago';
$string['dbgcolor'] = 'Deprecated';
$string['ddmenu'] = 'Drop Down menu';
$string['default'] = 'Default';
$string['demoimage'] = 'https://dummyimage.com/{$a->size}/{$a->color}.{$a->ext}';
$string['description'] = 'Description';
$string['discusage'] = 'Disk usage';
$string['diskusage'] = 'Disk usage';
$string['documentation'] = 'Deprecated';
$string['dshbdsbl'] = 'Disable custom dashboard for user roles';
$string['dyslexia'] = 'Dyslexia';
$string['dyslexic'] = 'Dyslexia-friendly font <span class="d-block tsizexsmall">OpenDyslexic</span>';
$string['editingfw'] = 'Full width content on editing mode';
$string['elrollsections'] = 'Course sections';
$string['emptycategories'] = 'Empty categories';
$string['enrolbtn'] = 'Always show enrol button';
$string['enrolform_course_code'] = 'Enrolment Code';
$string['enrollayout'] = 'Deprecated';
$string['enrollmentpage'] = 'Course enrolment page';
$string['enroltextfree'] = 'Enrol now';
$string['enroltextprice'] = 'Enrol in course for <span class="price"><span class="currency" aria-hidden="true">{$a->currency}</span><span class="cost">{$a->cost}</span><span class="sr-only">{$a->sr_currency}</span></span>';
$string['entercourse'] = 'Enter this course';
$string['eventdateshort'] = '<span class="month">%b</span><span class="day">%d</span>';
$string['eventdaydate'] = '<span class="dtime">%A, %d %B %I:%M <span class="pm-am">%p</span></span>';
$string['eventhourdate'] = '<span class="dtime">%I:%M <span class="pm-am">%p</span></span>';
$string['eventmonitoring'] = 'Event monitoring';
$string['eventsplaceholder'] = 'Event placeholder image';
$string['excludecat'] = 'Exclude category ID\'s';
$string['excludecat_desc'] = 'Comma-separated category ID\'s.';
$string['excludedlinks'] = 'Excluded items';
$string['excludedlinksdesc'] = 'Comma separated items which you want to exclude from the quick links menu: <ul><li>dashboard - my dashboard page</li><li>frontpage - front page</li><li>calendar - calendar page</li><li>badges - my badges page</li><li>mycourses - my courses page (Moodle 4+)</li><li>courses - all courses page</li><li>addcourse - new course page</li><li>addcategory - new category page</li><li>editcourse - course edit page</li><li>editcategory - category edit page</li></ul>';
$string['exctags'] = 'Exclude tag ID\'s';
$string['exctags_desc'] = 'Comma-separated tag ID\'s.';
$string['expiredcourses'] = 'Expired courses';
$string['explorecategory'] = 'View all courses in category: {$a->category}';
$string['fade'] = 'Fade';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Upload favicon image in "ico" format.';
$string['faviconimg'] = 'Favicon';
$string['ffamily'] = 'Font';
$string['ficon7stroke'] = 'Stroke Icons 7';
$string['ficonfa'] = 'Font Awesome';
$string['filterfields'] = 'Custom field filters';
$string['filterfields_desc'] = 'This option works with the \'dropdown menu\' field type. Each line consists separated by pipe character (|): field_short_name|filter_type.<br>For example:<pre>level
language|radio
</pre>';
$string['filterpos'] = 'Course filter position';
$string['firstloginmsg'] = 'Your account was created on <b>{$a->timecreated}</b>. To change your account details go to the <a href="{$a->profileurl}">profile page</a>.';
$string['folderisempty'] = 'Images folder is empty.';
$string['foldernoexists'] = 'Images folder does not exists.';
$string['fontname'] = 'Font name';
$string['fontstyle'] = 'Font style';
$string['fontsubset'] = 'Deprecated';
$string['footer'] = 'Footer';
$string['footer_desc'] = 'Skip all options below if you select footer from the Footer Builder.';
$string['footlogin'] = 'Deprecated';
$string['foottext'] = 'Footer Content';
$string['forgotpage'] = 'Forgot password/username page';
$string['fp2course'] = 'Redirect to courses page';
$string['frontpage'] = 'Front page';
$string['frontpagebuilder'] = 'Front page builder';
$string['fsize'] = 'Font size (rem)';
$string['fsizepx'] = 'Font size (px)';
$string['fsmodheaderdark'] = 'Dark header';
$string['fsmodhome'] = 'Course home section';
$string['fsmodnav'] = 'Breadcrumb navigation';
$string['fsmods'] = 'Show sidebar';
$string['fsmodsingle'] = 'Full-screen/Focus mode for the single activity format';
$string['fstyle'] = 'Deprecated';
$string['fullscreenmod'] = 'Full-screen/focus mode';
$string['fweight'] = 'Font weight';
$string['fweightbold'] = 'Font weight: bold';
$string['fweightlight'] = 'Font weight: light';
$string['fweightmedium'] = 'Font weight: medium';
$string['fweightnormal'] = 'Font weight: normal';
$string['fweightsemibold'] = 'Font weight: semi bold';
$string['ganaasync'] = 'Alternative Async Tracking';
$string['ganaid'] = 'Tracking ID (GA3)';
$string['ganaiddesc'] = 'Google Analytics 3 tracking ID: "UA-XXXXX-Y"';
$string['ganaiddesc_ga4'] = 'Google Analytics 4 tracking ID: "G-XXX..."';
$string['ganaidga4'] = 'Tracking ID (GA4)';
$string['ganatitle'] = 'Tracking code';
$string['general'] = 'General';
$string['gfont'] = 'Google font';
$string['gfonts'] = 'Google fonts';
$string['global'] = 'Global';
$string['gotosection'] = 'Go to section {$a}';
$string['gradcolor'] = 'Gradient color {$a}';
$string['gradcolordesc'] = 'Background color if \'Gradient background\' option is disabled.';
$string['h_pagetitle'] = 'Page title section';
$string['hbgcolor'] = 'Header background color';
$string['header'] = 'Header';
$string['headerbgcolor'] = 'Deprecated';
$string['headerbtn'] = 'Header buttons';
$string['headerbtndesc'] = 'Each line consists separated by pipe characters "|":<br>button text|url::"1" to open link in a new window|language code or comma-separated codes|"1" to show text for logged in users only or "2" to show text for guests only.<br>For example:<pre>For guests|http://example.com||2
For users|http://example.com||1</pre>';
$string['headercontent'] = 'Header content';
$string['headercontentdesc'] = 'Each line consists separated by pipe characters (|):<br>text::optional icon name|optional url::"1" to open link in a new window|language code or comma-separated codes|"1" to show text for logged in users only or "2" to show text for none logged in users only.<br>For example:<pre>Text with icon::fa-life-ring
Link with icon open in a new window::fa-link|http://example.com::1
English text||en
Spanish link text|http://example.com|es
English and Spanish text||en,es
Text for logged in users|||1
Text for guests|||2</pre>';
$string['headercontentmt'] = 'Deprecated';
$string['headergradbg'] = 'Gradient background';
$string['headerimg'] = 'Deprecated';
$string['headernav'] = 'Main menu position';
$string['headerstyle'] = 'Header style';
$string['headerstyleheading'] = 'Header';
$string['headertoolstext'] = 'Deprecated';
$string['headertoolstype'] = 'Deprecated';
$string['headingaboutcourse'] = 'About the course';
$string['headingactivities'] = 'This course includes';
$string['headinginstructors'] = 'Instructors';
$string['headingrequirements'] = 'Requirements';
$string['headings'] = 'Headings';
$string['headingscolor'] = 'Headings color';
$string['headingsections'] = 'Course content';
$string['headingsocial'] = 'Share this course';
$string['headingwhatlearn'] = 'What you\'ll learn';
$string['hidden'] = 'Hidden';
$string['hide'] = 'Hide';
$string['hideadminblocks'] = 'Hide admin blocks';
$string['hideimages'] = 'Hide images';
$string['hidesidebar'] = 'Hide sidebars';
$string['highcontrast'] = 'High contrast';
$string['highlightbuttons'] = 'Highlight buttons';
$string['highlighted'] = 'Highlighted';
$string['highlightlinks'] = 'Highlight links';
$string['highlighttitles'] = 'Highlight headings';
$string['highsaturation'] = 'High saturation';
$string['homeitem'] = 'Home item';
$string['hoursago'] = '<span class="timeago">{$a} hours</span> ago';
$string['hsize'] = 'Heading {$a->hsize} size (rem)';
$string['hue'] = 'Hue';
$string['icon'] = 'Icon';
$string['icondesc'] = 'Font icon name, e.g. \'fa-envelope\'.';
$string['image'] = 'Image';
$string['imgdefault'] = 'Default image';
$string['info'] = 'Info';
$string['inherit'] = 'Inherit';
$string['instructors'] = 'Instructors';
$string['inverse'] = 'Inverse';
$string['invertcolors'] = 'Invert colors';
$string['italic'] = 'Italic';
$string['justify'] = 'Distribute items evenly';
$string['lang1'] = 'Deprecated';
$string['lang2'] = 'Deprecated';
$string['langflags'] = 'Language flags images';
$string['langfooter'] = 'Language list in footer';
$string['langimg'] = 'Language flag';
$string['langinmenu'] = 'Languages';
$string['langmargin'] = 'Deprecated';
$string['langmenu'] = 'Language list in menu';
$string['langpos'] = 'Deprecated';
$string['language'] = 'Language';
$string['lastdays'] = 'Last {$a} days';
$string['lasthour'] = 'Last hour';
$string['lastloginmsg'] = 'Your last login was {$a->loginago}.';
$string['lastlogncoursemsg'] = 'Your last login was {$a->loginago}. Recently accessed course: <b>{$a->recentcourse}</b>.';
$string['layout'] = 'Layout';
$string['layoutfw'] = 'Full width';
$string['layoutfx'] = 'Boxed';
$string['layoutgrid'] = 'Grid';
$string['layoutlist'] = 'List';
$string['layoutn'] = 'Layout {$a->layout}';
$string['lbgcolor'] = 'Light background color';
$string['learning'] = 'Learning';
$string['left'] = 'Left';
$string['light'] = 'Light';
$string['lightboxvideo'] = 'Video in lightbox: {$a->videourl}';
$string['lighter'] = 'Lighter';
$string['lightness'] = 'Lightness';
$string['lightschemeheading'] = 'Light color scheme';
$string['lighttransparentheading'] = 'Transparent light header style';
$string['link'] = 'Link';
$string['linkcolor'] = 'Links color';
$string['linkhcolor'] = 'Links hover color';
$string['links'] = 'Links';
$string['livelogs'] = 'Live logs';
$string['loading'] = 'Loading...';
$string['loadinghide'] = 'Hide screen after (ms)';
$string['loadinglogodesc'] = 'Leave it empty to use default logo on loading page.';
$string['loadingscr'] = 'Loading screen';
$string['loadingscrdesc'] = 'Loading screen is NOT visible for admin user.';
$string['loadingscreen'] = 'Loading screen';
$string['loadmore'] = 'Load more posts';
$string['loginbtn'] = 'Login button';
$string['loginbtntype'] = 'Login button type';
$string['loginform'] = 'Login Form';
$string['logininfo'] = 'Deprecated';
$string['loginlink'] = 'Deprecated';
$string['loginlinktopage'] = 'Link to Login Page';
$string['loginlogodesc'] = 'Deprecated';
$string['loginpage'] = 'Custom login page';
$string['loginsearchform'] = 'Login and search form';
$string['logintext'] = 'Deprecated';
$string['logo'] = 'Logo and favicon';
$string['logoalttext'] = 'Deprecated';
$string['logoalttextdesc'] = 'Deprecated';
$string['logodarkimg'] = 'Logo dark';
$string['logodarkimgsm'] = 'Logo small dark';
$string['logoh'] = 'Logo height (px)';
$string['logohdesc'] = 'Logo height in pixels. Logo width will be set automatically.';
$string['logohsm'] = 'Logo small height (px)';
$string['logoimg'] = 'Logo';
$string['logoimgsm'] = 'Logo small';
$string['logom'] = 'Deprecated';
$string['logotitle'] = 'Deprecated';
$string['logotitledesc'] = 'Deprecated';
$string['logow'] = 'Deprecated';
$string['logowdesc'] = 'Deprecated';
$string['lowercase'] = 'Lowercase';
$string['lowsaturation'] = 'Low saturation';
$string['mainmenu'] = 'Main menu';
$string['margindesc'] = 'Margin: top right bottom left.';
$string['mb2builder_plugin_update'] = 'Go to: <i>Site administration > Plugins > Install plugins</i> and install the latest version of the page builder plugin (local_mb2builder-x.x.x.zip).';
$string['mb2shortcodes_button_plugin'] = 'Deprecated';
$string['mb2shortcodes_filter_plugin'] = 'Go to: <i>Site administration > Plugins > Filters > Manage filters</i> and activate the &#34;Mb2 Shortcodes&#34; filter.';
$string['mb2shortcodes_filter_plugin_installed'] = 'Go to: <i>Site administration > Plugins > Install plugins</i> and install the FILTER_mb2shortcodes-x.x.x.zip file.';
$string['mb2slider_plugin'] = 'Deprecated';
$string['mb2slides_plugin'] = 'Mb2 Slides plugin must be installed.';
$string['mb2slides_plugin_empty'] = 'Mb2 Slides plugin is installed! Go to plugin page to <a href="{$a->link}">Manage slides</a>.';
$string['medium'] = 'Medium';
$string['menu'] = 'Menu';
$string['minimal'] = 'Minimal';
$string['modal_eventdate'] = '<span class="dtime">%A, %d %B %Y</span>';
$string['modal_eventdaydate'] = '<span class="dtime">%d %B %I:%M <span class="pm-am">%p</span></span>';
$string['modaltools'] = 'Login and search form in modal window';
$string['modern'] = 'Modern';
$string['monochrome'] = 'Monochrome';
$string['morecat'] = 'Deprecated';
$string['moreinstructor'] = 'Deprecated';
$string['moretags'] = 'Deprecated';
$string['morethemes'] = 'Deprecated';
$string['mybookmarks'] = 'Bookmarks';
$string['mycexpierd'] = 'Deprecated';
$string['mychidden'] = 'Hidden courses';
$string['mycinmenu'] = 'My courses in menu';
$string['myclimit'] = 'Course name words limit';
$string['mycourse'] = 'My course';
$string['name'] = 'Name';
$string['navalign'] = 'Alignment';
$string['navaspeed'] = 'Deprecated';
$string['navatype'] = 'Deprecated';
$string['navatypefade'] = 'Deprecated';
$string['navatypeslide'] = 'Deprecated';
$string['navbarbgcolor'] = 'Navigation bar background color';
$string['navbarplugin'] = 'Navbar plugin';
$string['navbarsearch'] = 'Search in navigation bar';
$string['navcls'] = 'Deprecated';
$string['navclsdesc'] = 'Deprecated';
$string['navcolor'] = 'Menu item color';
$string['navddwidth'] = 'Dropdown list width (px)';
$string['navforusers'] = 'Menu for logged in users';
$string['navhbgcolor'] = 'Menu item hover background color';
$string['navhcolor'] = 'Menu item hover color';
$string['navicon'] = 'Icon navigation';
$string['naviconfsize'] = 'Deprecated';
$string['naviconsdesc'] = 'Each line consists separated by pipe characters (|):<br>text::icon name|optional url::"1" to open link in a new window|language code or comma-separated codes|"1" to show text for logged in users only or "2" to show text for none logged in users only.<br>For example:<pre>Link with icon::fa-life-ring|http://example.com
Link with icon open in a new window::fa-link|http://example.com::1
English text::fa-flag||en
Spanish link text::fa-star|http://example.com|es
English and Spanish text::fa-globe||en,es
Text for logged in users::fa-lock|||1
Text for guests::fa-unlock|||2</pre>';
$string['navsep'] = 'Menu item separator/border';
$string['navsepcolor'] = 'Menu item separator/border color';
$string['navsubcolor'] = 'Menu item subtext color';
$string['navsubhcolor'] = 'Menu item subtext hover color';
$string['nbsp'] = 'Non-breaking space';
$string['newuserstime'] = 'User new time (days)';
$string['nfont'] = 'Normal font';
$string['nfonts'] = 'Normal fonts';
$string['no'] = 'No';
$string['nobodyenrolled'] = 'Be the first to enrol!';
$string['nocourseincategory'] = 'No courses';
$string['nocriteriaset'] = 'No completion criteria';
$string['none'] = 'None';
$string['noprice'] = 'Free';
$string['normal'] = 'Normal';
$string['nostudentpanel'] = 'Deprecated';
$string['oblique'] = 'Oblique';
$string['onepagenav'] = 'One page navigation';
$string['onlineusers'] = 'Online';
$string['onthispage'] = 'On this page';
$string['openlink'] = 'Open Link';
$string['openlinkblank'] = 'In a new window';
$string['openlinkself'] = 'In the same window';
$string['options'] = 'Options';
$string['optsidebar'] = 'Sidebar';
$string['opttop'] = 'Top';
$string['ordering'] = 'Ordering';
$string['orderingdesc'] = 'Leave it empty to use default ordering.';
$string['orientationadjustments'] = 'Orientation adjustments';
$string['overview'] = 'Overview';
$string['pagecls'] = 'Deprecated';
$string['pageclsdesc'] = 'Deprecated';
$string['pagelogin'] = 'Deprecated';
$string['pagestyle'] = 'Page';
$string['pagewidth'] = 'Page width (px)';
$string['paid'] = 'Paid';
$string['panellinkincontent'] = 'Deprecated';
$string['partnerlogos'] = 'Partner logos';
$string['partnerslinks'] = ' Partner links';
$string['partnerslinksdesc'] = 'Each line consists separated by pipe characters (|):partner name|url::"1" to open link in a new window.<br>For example:<pre>Parnter #1 name|http://example.com
Parnter #2 name|http://example.com::1</pre>';
$string['pastcourses'] = 'Past';
$string['pbgdesc'] = 'To see page background color or image you need ot use \'Boxed\' page layout.';
$string['pbgimagescroll'] = 'Deprecated';
$string['pbgpre'] = 'Predefined background';
$string['playbtn'] = 'Play video';
$string['plugincss'] = 'Plugin style files';
$string['plugincssdesc'] = 'Each line consists plugin style file name.<br>You can set the following style file names:<pre>plugin-buttons
plugin-grid
plugin-iomad
plugin-mb2sections
plugin-tiles
plugin-topcoll
</pre>';
$string['pluginname'] = 'New Learning';
$string['popularlinks'] = 'Popular links:';
$string['posheader'] = 'Header';
$string['posheader2'] = 'Header 2';
$string['posnavbar'] = 'Navigation bar';
$string['preformanceproblems'] = 'Performance problems';
$string['price'] = 'Price';
$string['pricedecimal'] = 'Course price decimal point';
$string['pricesep'] = 'Course price thousands separator';
$string['primary'] = 'Primary';
$string['progress'] = 'Progress';
$string['quicklinks'] = 'Quick links';
$string['quickview'] = 'Quick view';
$string['rating'] = '{$a->name}, rating {$a->rating}';
$string['readablefont'] = 'Readable font';
$string['readingguide'] = 'Reading guide';
$string['readingmask'] = 'Reading Mask';
$string['readmore'] = 'Read more';
$string['recyclebin'] = 'Recycle bin';
$string['region-adminblock'] = 'Adminblock';
$string['region-after-content'] = 'After Content';
$string['region-after-slider'] = 'After Slider';
$string['region-banner-bottom'] = 'Deprecated';
$string['region-banner-top'] = 'Deprecated';
$string['region-before-content'] = 'Before Content';
$string['region-bottom'] = 'Bottom';
$string['region-bottom-a'] = 'Bottom A';
$string['region-bottom-b'] = 'Bottom B';
$string['region-bottom-c'] = 'Bottom C';
$string['region-bottom-d'] = 'Bottom D';
$string['region-content-bottom'] = 'Content Bottom';
$string['region-content-top'] = 'Content Top';
$string['region-side-post'] = 'Side Post';
$string['region-side-pre'] = 'Side Pre';
$string['region-slider'] = 'Slider';
$string['regionnogrid'] = 'Deprecated';
$string['regions'] = 'Deprecated';
$string['register'] = 'Register';
$string['registerbtntype'] = 'Register button type';
$string['resetsettings'] = 'Reset settings';
$string['reviews'] = 'Reviews';
$string['right'] = 'Right';
$string['roleshortname'] = 'Deprecated';
$string['saturation'] = 'Saturation';
$string['scrollspeed'] = 'Scroll speed (ms)';
$string['scrolltt'] = 'Scroll to top';
$string['scustomcssstyleheading'] = 'Custom css style';
$string['searchlinks'] = 'Search links';
$string['searchlinksdesc'] = 'Each line consists separated by pipe characters (|):<br>link text|url::"1" to open link in a new window|language code or comma-separated codes|"1" to show text for logged in users only or "2" to show text for none logged in users only.<br>For example:<pre>Link text|http://example.com
Link open in a new window|http://example.com::1
English link text text|http://example.com|en
Spanish link text|http://example.com|es
English and Spanish link text|http://example.com|en,es
Link for logged in users|http://example.com||1
Link for guests|http://example.com||2</pre>';
$string['secnav'] = 'Secondary menu';
$string['secondary'] = 'Secondary';
$string['sectionnofn'] = 'Section {$a->num} of {$a->count}';
$string['sectionpadding'] = 'Top,bottom padding';
$string['sectionpaddingdesc'] = 'Comma separated padding top and bottom in pixels, e.g. \'20,20\'.';
$string['seizureandepileptic'] = 'Seizure and epileptic';
$string['semibold'] = 'Semi bold';
$string['sep'] = 'Separator';
$string['settingscourses'] = 'Courses';
$string['settingsfeatures'] = 'Features';
$string['settingsfonts'] = 'Font';
$string['settingsgeneral'] = 'General';
$string['settingslink'] = 'Theme Settings';
$string['settingsnav'] = 'Menus';
$string['settingssocial'] = 'Social';
$string['settingsstyle'] = 'Style';
$string['settingstogglecat'] = 'Toggle settings: {$a}';
$string['settingstypography'] = 'Typography';
$string['shapen'] = 'Shape {$a}';
$string['shareemail'] = 'Email';
$string['sharefacebook'] = 'Facebook';
$string['shareicons'] = 'Share icons';
$string['sharelinkedin'] = 'LinkedIn';
$string['sharetwitter'] = 'Twitter';
$string['shareurl'] = 'URL';
$string['show'] = 'Show';
$string['showadminblocks'] = 'Show admin blocks';
$string['showmorebtn'] = 'More/less button';
$string['showsidebar'] = 'Show sidebars';
$string['sidebar'] = 'Sidebar';
$string['sidebarbtn'] = 'Show/hide sidebars';
$string['sidebarbtntext'] = 'Text sidebar button';
$string['sidebarpos'] = 'Sidebars position';
$string['sidebarposcourse'] = 'Deprecated';
$string['sidebaryeshide'] = 'Yes and hide sidebars';
$string['sidebaryesshow'] = 'Yes and show sidebars';
$string['signuplink'] = 'Deprecated';
$string['signuppage'] = 'Custom signup page url';
$string['sitemenu'] = 'Deprecated';
$string['sitemenufp'] = 'Deprecated';
$string['sitemnuitems'] = 'Deprecated';
$string['sitemnuitemsdesc'] = 'Deprecated';
$string['skipacsb'] = 'Skip accessibility options';
$string['skipel'] = 'Skip {$a->skipel}';
$string['skiptoaccessibilitymenu'] = 'Skip to accessibility options';
$string['skiptofooter'] = 'Skip to footer';
$string['skiptologin'] = 'Skip to login form';
$string['skiptonavigation'] = 'Skip to navigation';
$string['skiptoprofile'] = 'Skip to profile';
$string['skiptosearch'] = 'Skip to search form';
$string['slide'] = 'Slide';
$string['slidelower'] = 'slide';
$string['slider'] = 'Slider';
$string['slidernavnext'] = 'Move to the next slide';
$string['slidernavprev'] = 'Move to the previous slide';
$string['slidernext'] = 'Next slide';
$string['sliderpagination'] = 'Go to slide';
$string['sliderprev'] = 'Previous slide';
$string['snamelimit'] = 'Section name character limit';
$string['socialfooter'] = 'Footer icons';
$string['socialheader'] = 'Header icons';
$string['sociallinknw'] = 'Open links in a new widnow';
$string['socialmargin'] = 'Icon list top margin (px)';
$string['socialmargindesc'] = 'Deprecated';
$string['socialtt'] = 'Tooltip';
$string['socillist'] = 'Social icons';
$string['spinner'] = 'Spinner image';
$string['spinnerw'] = 'Spinner image size (px)';
$string['stickyheader'] = 'Deprecated';
$string['stickymobilenav'] = 'Sticky navigation on mobile';
$string['stickynav'] = 'Sicky navigation';
$string['stickysitemenu'] = 'Deprecated';
$string['stopanimations'] = 'Stop animations';
$string['strdatecourse'] = '%d %B %Y';
$string['strdatecourseshort'] = '%d %b %Y';
$string['strftimedatecourseupdated'] = 'Deprecated';
$string['strftimedatedaymonth'] = '%d %b';
$string['strftimedatemoncourselist'] = 'Deprecated';
$string['strftimedatemonthabbr'] = 'Deprecated';
$string['strip1'] = 'Strip left light';
$string['strip2'] = 'Strip left dark';
$string['studentroleshortname'] = 'Student role shortname';
$string['studentsandyou'] = '{$a->students} and you';
$string['studentsroleid'] = 'Deprecated';
$string['style'] = 'Style';
$string['subtitle'] = 'Sub Title';
$string['success'] = 'Success';
$string['tabalt'] = 'Alternative tabs';
$string['tbbgcolor'] = 'Top bar background color';
$string['tbdbgcolor'] = 'Deprecated';
$string['teachercourses'] = '{$a->courses} courses';
$string['teacheremail'] = 'Deprecated';
$string['teachermessage'] = 'Deprecated';
$string['teacherroleshortname'] = 'Teacher role shortname';
$string['teacherstudents'] = '{$a->students} students';
$string['text'] = 'Text';
$string['textcolor'] = 'Text color';
$string['textcolor_lighten'] = 'Text color lighter';
$string['textcolorondark'] = 'Text color on dark background';
$string['textdesc'] = 'Optional text.';
$string['textspacing'] = 'Text spacing';
$string['tgsdb'] = 'Toggle sidebar';
$string['tgsdbclose'] = 'Close sidebar';
$string['tgsdbclosetab'] = 'Close tab';
$string['tgsdbdef'] = 'Show sidebar by default';
$string['tgsdbfilters'] = 'Course filters in toggle sidebar';
$string['tgsdbnobp'] = 'Deprecated';
$string['tgsdbopen'] = 'Open sidebar';
$string['title'] = 'Title';
$string['toclimit'] = 'Limit sections';
$string['tocmore'] = '<span class="num">{$a}</span> more sections';
$string['tocsep'] = 'Deprecated';
$string['todayis'] = 'Today is <b>{$a}</b>.';
$string['togglecat'] = 'Category toggle list';
$string['togglecategory'] = 'Toggle subcategory: {$a}';
$string['togglefilter'] = 'Toggle course filter: {$a}';
$string['toggleheadercontent'] = 'Toggle extra content';
$string['togglelogin'] = 'Toggle login form';
$string['togglemenu'] = 'Toggle primary menu';
$string['togglemenuitem'] = 'Toggle submenu: {$a->menuitem}';
$string['togglesearch'] = 'Toggle search form';
$string['togglesection'] = 'Toggle section: {$a}';
$string['togglesections'] = 'Toggle course content';
$string['toolsicon'] = 'Deprecated';
$string['toolstext'] = 'Deprecated';
$string['tooltips'] = 'Tooltips';
$string['top'] = 'Top';
$string['topbar'] = 'Top bar';
$string['topmenu'] = 'Top menu';
$string['topmenudesc'] = 'Each line consists separated by pipe characters (|):<br>text|url::"1" to open link in a new window|language code or comma-separated codes|"1" to show item for logged in users only or "2" to show item for none logged in users only.<br>For example:<pre>Item|http://example.com
Item open in a new window|http://example.com::1
English item|http://example.com|en
Spanish item|http://example.com|es
Item for users|http://example.com||1
Item for guests|http://example.com||2</pre>';
$string['transparent'] = 'Transparent';
$string['transparent_light'] = 'Transparent light';
$string['transparentbg'] = 'Use colors for transparent header';
$string['tsettings'] = 'Theme settings';
$string['ttransform'] = 'Text transform';
$string['uppercase'] = 'Uppercase';
$string['url'] = 'Url';
$string['urldoc'] = 'Deprecated';
$string['urlmore'] = 'Deprecated';
$string['urlnw'] = 'Open in a new window';
$string['viewcourse'] = 'View course';
$string['visiblecourses'] = 'Visible courses';
$string['visualimpairment'] = 'Visual impairment';
$string['warning'] = 'Warning';
$string['wavebg'] = 'Deprecated';
$string['waven'] = 'Wave {$a}';
$string['website'] = 'Website';
$string['wentwrong'] = 'Something went wrong';
$string['xcolumns'] = '{$a} columns';
$string['xmoreteachers'] = '+{$a->teachers}';
$string['yes'] = 'Yes';
$string['yourprogress'] = 'Your progress';
