<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**

 *
 * @package   theme_mb2nl
 * @copyright 2017 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license   PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();


$mb2settingsrow = [
    'tabs' => [
        'general' => get_string('generaltab', 'local_mb2builder'),
        'style' => get_string('styletab', 'local_mb2builder'),
        'heroimg' => get_string('heroimg', 'local_mb2builder'),
        'bgtext' => get_string('bgtext', 'local_mb2builder'),
        'wave' => get_string('wavetab', 'local_mb2builder'),
    ],
    'attr' => [
        'rowlang' => [
            'type' => 'text',
            'section' => 'general',
            'title' => get_string('language', 'core'),
            'desc' => get_string('languagedesc', 'local_mb2builder'),
            'action' => 'text',
            'selector' => '.mb2-pb-actions .languages',
        ],
        'rowaccess' => [
            'type' => 'list',
            'section' => 'general',
            'title' => get_string('elaccess', 'local_mb2builder'),
            'options' => [
                0 => get_string('elaccessall', 'local_mb2builder'),
                1 => get_string('elaccessusers', 'local_mb2builder'),
                2 => get_string('elaccesguests', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'access',
            'class_remove' => 'access0 access1 access2',
        ],
        'rowhidden' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('hidden', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'hidden',
            'class_remove' => 'hidden0 hidden1',
        ],
        'spacer_row1' => ['type' => 'spacer', 'section' => 'general'],
        'fw' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('fullwidth', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'isfw',
            'class_remove' => 'isfw0 isfw1',
        ],
        'va' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('rowvalign', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'va',
            'class_remove' => 'va0 va1',
        ],
        'colgutter' => [
            'type' => 'buttons',
            'section' => 'general',
            'title' => get_string('colspace', 'local_mb2builder'),
            'options' => [
                'none' => get_string('none', 'local_mb2builder'),
                's' => get_string('small', 'local_mb2builder'),
                'm' => get_string('medium', 'local_mb2builder'),
                'l' => get_string('large', 'local_mb2builder'),
                'xl' => get_string('xlarge', 'local_mb2builder'),
            ],
            'default' => 's',
            'action' => 'class',
            'class_remove' => 'colgutter-none colgutter-m colgutter-s colgutter-l colgutter-xl',
            'class_prefix' => 'colgutter-',
        ],
        'spacer_row2' => ['type' => 'spacer', 'section' => 'general'],
        'pt' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('ptlabel', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 60,
            'action' => 'style',
            'changemode' => 'input',
            'numclass' => 1,
            'sizepref' => 'rowpt',
            'style_properity' => '--mb-pb-row_pt',
        ],
        'pb' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('pblabel', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'numclass' => 1,
            'sizepref' => 'rowpb',
            'style_properity' => '--mb-pb-row_pb',
        ],
        'mt' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('mt', 'local_mb2builder'),
            'min' => -300,
            'max' => 300,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => 'margin-top',
        ],
        'scheme' => [
            'type' => 'buttons',
            'section' => 'style',
            'title' => get_string('scheme', 'local_mb2builder'),
            'options' => [
                'light' => get_string('light', 'local_mb2builder'),
                'dark' => get_string('dark', 'local_mb2builder'),
            ],
            'default' => 'light',
            'action' => 'class',
            'class_remove' => 'light dark',
        ],
        'bgcolor' => [
            'type' => 'color',
            'section' => 'style',
            'title' => get_string('bgcolor', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-row_bgcolor',
        ],
        'obgimg' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('semitbgcolor', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 1,
            'action' => 'class',
            'class_prefix' => 'obgimg',
            'class_remove' => 'obgimg0 obgimg1',
        ],
        'prbg' => [
            'type' => 'list',
            'section' => 'style',
            'title' => get_string('prestyle', 'local_mb2builder'),
            'options' => [
                0 => get_string('none', 'local_mb2builder'),
                'gradient20' => get_string('gradient20', 'local_mb2builder'),
                'gradient40' => get_string('gradient40', 'local_mb2builder'),
                'strip1' => get_string('strip1', 'local_mb2builder'),
                'strip2' => get_string('strip2', 'local_mb2builder'),
                'strip3' => get_string('strip3', 'local_mb2builder'),
                'strip4' => get_string('strip4', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'pre-bg',
            'class_remove' => 'pre-bggradient20 pre-bggradient40 pre-bgstrip1 pre-bgstrip2 pre-bgstrip3 pre-bgstrip4',
        ],
        'group_row_start_1' => ['type' => 'group_start', 'section' => 'style',
        'title' => get_string('bgimage', 'local_mb2builder')], // Group start.
        'bgimage' => [
            'type' => 'image',
            'section' => 'style',
            'title' => get_string('bgimage', 'local_mb2builder'),
            'action' => 'image',
            'style_properity' => 'background-image',
        ],
        'bgfixed' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('bgfixed', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'bgfixed',
            'class_remove' => 'bgfixed0 bgfixed1',
        ],
        'parallax' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('parallax', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'parallax',
            'class_remove' => 'parallax0 parallax1',
        ],
        'group_row_end_1' => ['type' => 'group_end', 'section' => 'style'], // Group end.
        'group_row_start_3' => ['type' => 'group_start', 'section' => 'style',
        'title' => get_string('bgvideo', 'local_mb2builder')], // Group start.
        'bgvideo' => [
            'type' => 'image',
            'section' => 'style',
            'title' => get_string('bgvideo', 'local_mb2builder'),
            'action' => 'image',
            'selector' => '.section-video',
        ],
        'group_row_end_3' => ['type' => 'group_end', 'section' => 'style'], // Group end.
        'group_row_start_2' => ['type' => 'group_start', 'section' => 'style',
        'title' => get_string('gradient', 'local_mb2builder')], // Group start.
        'gradient' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('gradient', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'rowgrad',
            'class_remove' => 'rowgrad0 rowgrad1',
        ],
        'graddeg' => [
            'type' => 'range',
            'section' => 'style',
            'showon' => 'gradient:1',
            'title' => get_string('angle', 'local_mb2builder'),
            'min' => 0,
            'max' => 360,
            'default' => 45,
            'action' => 'gradient',
        ],
        'gradcolor1' => [
            'type' => 'color',
            'showon' => 'gradient:1',
            'section' => 'style',
            'title' => get_string('gradcolorn', 'local_mb2builder', ['n' => 1]),
            'action' => 'color',
            'selector' => '.rowgrad',
            'style_properity' => 'background-color',
            'default' => '#37E2D5',
        ],
        'gradloc1' => [
            'type' => 'range',
            'section' => 'style',
            'showon' => 'gradient:1',
            'title' => get_string('gradloc1', 'local_mb2builder'),
            'min' => 0,
            'max' => 100,
            'default' => 0,
            'action' => 'gradient',
        ],
        'gradcolor2' => [
            'type' => 'color',
            'showon' => 'gradient:1',
            'section' => 'style',
            'title' => get_string('gradcolorn', 'local_mb2builder', ['n' => 2]),
            'action' => 'color',
            'selector' => '.rowgrad',
            'style_properity' => 'background-color',
            'default' => '#590696',
        ],
        'gradloc2' => [
            'type' => 'range',
            'section' => 'style',
            'showon' => 'gradient:1',
            'title' => get_string('gradloc2', 'local_mb2builder'),
            'min' => 0,
            'max' => 100,
            'default' => 100,
            'action' => 'gradient',
        ],
        'group_row_end_2' => ['type' => 'group_end', 'section' => 'style'], // Group end.
        'group_row_start_7' => ['type' => 'group_start', 'section' => 'style',
        'title' => get_string('border', 'local_mb2builder')], // Group start.
        'bordert' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('bordert', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'bordert',
            'class_remove' => 'bordert0 bordert1',
        ],
        'bordertcolor' => [
            'type' => 'color',
            'showon' => 'bordert:1',
            'section' => 'style',
            'title' => get_string('color', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-row_btcolor',
            'default' => '#dddddd',
        ],
        'bordertw' => [
            'type' => 'range',
            'section' => 'style',
            'showon' => 'bordert:1',
            'title' => get_string('borderw', 'local_mb2builder'),
            'min' => 1,
            'max' => 100,
            'step' => 1,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => '--mb-pb-row_btw',
        ],
        'borderb' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('borderb', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'borderb',
            'class_remove' => 'borderb0 borderb1',
        ],
        'borderbcolor' => [
            'type' => 'color',
            'showon' => 'borderb:1',
            'section' => 'style',
            'title' => get_string('color', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-row_bbcolor',
            'default' => '#dddddd',
        ],
        'borderbw' => [
            'type' => 'range',
            'section' => 'style',
            'showon' => 'borderb:1',
            'title' => get_string('borderw', 'local_mb2builder'),
            'min' => 1,
            'max' => 100,
            'step' => 1,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => '--mb-pb-row_bbw',
        ],
        'borderfw' => [
            'type' => 'yesno',
            'section' => 'style',
            'title' => get_string('fullwidth', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 1,
            'action' => 'class',
            'class_prefix' => 'borderfw',
            'class_remove' => 'borderfw0 borderfw1',
        ],
        'group_row_end_7' => ['type' => 'group_end', 'section' => 'style'], // Group end.
        'heroimg' => [
            'type' => 'yesno',
            'section' => 'heroimg',
            'title' => get_string('heroimg', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'heroimg',
            'class_remove' => 'heroimg0 heroimg1',
        ],
        'heroonsmall' => [
            'type' => 'yesno',
            'section' => 'heroimg',
            'title' => get_string('smallscreen', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 1,
            'action' => 'class',
            'class_prefix' => 'heroonsmall',
            'class_remove' => 'heroonsmall0 heroonsmall1',
        ],
        'heroimgurl' => [
            'type' => 'image',
            'section' => 'heroimg',
            'title' => get_string('image', 'local_mb2builder'),
            'action' => 'image',
            'selector' => '.hero-img',
        ],
        'heroalttext' => [
            'type' => 'text',
            'section' => 'heroimg',
            'title' => get_string('alttext', 'local_mb2builder'),
        ],
        'herow' => [
            'type' => 'range',
            'section' => 'heroimg',
            'title' => get_string('widthlabel', 'local_mb2builder'),
            'min' => 50,
            'max' => 2000,
            'default' => 1200,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.hero-img-wrap3',
            'style_properity' => 'width',
        ],
        'herov' => [
            'type' => 'buttons',
            'section' => 'heroimg',
            'title' => get_string('alignv', 'local_mb2builder'),
            'options' => [
                'top' => get_string('top', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
                'bottom' => get_string('bottom', 'local_mb2builder'),
            ],
            'default' => 'center',
            'action' => 'class',
            'class_remove' => 'herovtop herovcenter herovbottom',
            'class_prefix' => 'herov',
        ],
        'heromt' => [
            'type' => 'range',
            'section' => 'heroimg',
            'title' => get_string('vpospixel', 'local_mb2builder'),
            'min' => -500,
            'max' => 500,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.hero-img-wrap3',
            'style_properity' => '--mb2-pb-herovm',
        ],
        'herohpos' => [
            'type' => 'buttons',
            'section' => 'heroimg',
            'title' => get_string('alignh', 'local_mb2builder'),
            'options' => [
                'left' => get_string('left', 'local_mb2builder'),
                'right' => get_string('right', 'local_mb2builder'),
            ],
            'default' => 'left',
            'action' => 'setting',
            'setting' => 'heroml',
        ],
        'heroml' => [
            'type' => 'range',
            'section' => 'heroimg',
            'title' => get_string('hpos', 'local_mb2builder'),
            'min' => -99,
            'max' => 99,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.hero-img-wrap3',
            'style_properity' => 'left',
            'style_suffix' => '%',
        ],
        'herogradl' => [
            'type' => 'yesno',
            'section' => 'heroimg',
            'title' => get_string('herogradl', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'herogradl',
            'class_remove' => 'herogradl0 herogradl1',
        ],
        'herogradr' => [
            'type' => 'yesno',
            'section' => 'heroimg',
            'title' => get_string('herogradr', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'herogradr',
            'class_remove' => 'herogradr0 herogradr1',
        ],
        'wave' => [
            'type' => 'buttons',
            'section' => 'wave',
            'title' => get_string('wave', 'local_mb2builder'),
            'options' => [
                'none' => get_string('none', 'local_mb2builder'),
                '1' => get_string('waven', 'local_mb2builder', ['n' => 1]),
                '2' => get_string('waven', 'local_mb2builder', ['n' => 2]),
                '3' => get_string('waven', 'local_mb2builder', ['n' => 3]),
                '4' => get_string('waven', 'local_mb2builder', ['n' => 4]),
            ],
            'default' => 'none',
            'action' => 'class',
            'class_remove' => 'wave-none wave-1 wave-2 wave-3 wave-4',
            'class_prefix' => 'wave-',
        ],
        'wavepos' => [
            'type' => 'buttons',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('position', 'local_mb2builder'),
            'options' => [
                '0' => get_string('bottom', 'local_mb2builder'),
                '1' => get_string('top', 'local_mb2builder'),
            ],
            'default' => '0',
            'action' => 'class',
            'class_prefix' => 'wavepos',
            'class_remove' => 'wavepos0 wavepos1',
        ],
        'wavefliph' => [
            'type' => 'yesno',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('fliph', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'wavefliph',
            'class_remove' => 'wavefliph0 wavefliph1',
        ],
        'waveover' => [
            'type' => 'yesno',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('overcontent', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 1,
            'action' => 'class',
            'class_prefix' => 'waveover',
            'class_remove' => 'waveover0 waveover1',
        ],
        'wavecolor' => [
            'type' => 'color',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('wavecolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-row-wave path',
            'style_properity' => 'fill',
            'default' => '#ffffff',
        ],
        'wavewidth' => [
            'type' => 'range',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('widthlabel', 'local_mb2builder'),
            'min' => 100,
            'max' => 1000,
            'default' => 100,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-row-wave svg',
            'style_properity' => 'width',
            'style_suffix' => '%',
        ],
        'waveheight' => [
            'type' => 'range',
            'section' => 'wave',
            'showon' => 'wave:1|2|3|4',
            'title' => get_string('height', 'local_mb2builder'),
            'min' => 10,
            'max' => 500,
            'default' => 55,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-row-wave svg',
            'style_properity' => 'height',
        ],
        'bgtext' => [
            'type' => 'yesno',
            'section' => 'bgtext',
            'title' => get_string('bgtext', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'bgtext',
            'class_remove' => 'bgtext0 bgtext1',
        ],
        'bgtextmob' => [
            'type' => 'yesno',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('onmobile', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'class_prefix' => 'bgtextmob',
            'class_remove' => 'bgtextmob0 bgtextmob1',
        ],
        'bgtexttext' => [
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'type' => 'text',
            'title' => get_string('text', 'local_mb2builder'),
            'action' => 'text',
            'selector' => '.bgtext-text',
            'default' => 'Sample text',
        ],
        'btcolor' => [
            'type' => 'color',
            'showon' => 'bgtext:1',
            'section' => 'bgtext',
            'title' => get_string('color', 'local_mb2builder'),
            'action' => 'color',
            'default' => 'rgba(0,0,0,.05)',
            'selector' => '.bgtext-text',
            'style_properity' => 'color',
        ],
        'bth' => [
            'type' => 'buttons',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('alignh', 'local_mb2builder'),
            'options' => [
                'left' => get_string('left', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
                'right' => get_string('right', 'local_mb2builder'),
            ],
            'default' => 'none',
            'action' => 'class',
            'selector' => '.bgtext',
            'class_remove' => 'bthleft bthright bthcenter',
            'class_prefix' => 'bth',
        ],
        'btv' => [
            'type' => 'buttons',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('alignv', 'local_mb2builder'),
            'options' => [
                'top' => get_string('top', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
                'bottom' => get_string('bottom', 'local_mb2builder'),
            ],
            'default' => 'none',
            'action' => 'class',
            'selector' => '.bgtext',
            'class_remove' => 'btvtop btvcenter btvbottom',
            'class_prefix' => 'btv',
        ],
        'btsize' => [
            'type' => 'range',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('sizelabel', 'local_mb2builder', ''),
            'min' => 1,
            'max' => 1000,
            'step' => 1,
            'default' => 290,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.bgtext-text',
            'style_properity' => 'font-size',
            'style_suffix' => 'px',
        ],
        'btfwcls' => [
            'type' => 'buttons',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('fweight', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'light' => get_string('fwlight', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
                'medium' => get_string('wmedium', 'local_mb2builder'),
                'semibold' => get_string('semibold', 'local_mb2builder'),
                'bold' => get_string('fwbold', 'local_mb2builder'),
            ],
            'default' => 'bold',
            'action' => 'class',
            'selector' => '.bgtext-text',
            'class_remove' => 'fwglobal fwlight fwnormal fwmedium fwsemibold fwbold',
            'class_prefix' => 'fw',
        ],
        'btlh' => [
            'type' => 'range',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('lh', 'local_mb2builder'),
            'min' => 0.5,
            'max' => 3,
            'step' => .01,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.bgtext-text',
            'style_suffix' => 'em',
            'style_properity' => 'line-height',
        ],
        'btlspacing' => [
            'type' => 'range',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('lspacing', 'local_mb2builder'),
            'min' => -10,
            'max' => 30,
            'step' => 1,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.bgtext-text',
            'style_properity' => 'letter-spacing',
        ],
        'btwspacing' => [
            'type' => 'range',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('wspacing', 'local_mb2builder'),
            'min' => -10,
            'max' => 30,
            'step' => 1,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.bgtext-text',
            'style_properity' => 'word-spacing',
        ],
        'btupper' => [
            'type' => 'yesno',
            'section' => 'bgtext',
            'showon' => 'bgtext:1',
            'title' => get_string('uppercase', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.bgtext-text',
            'class_remove' => 'upper0 upper1',
            'class_prefix' => 'upper',
        ],
        'custom_class' => [
            'type' => 'text',
            'section' => 'style',
            'title' => get_string('customclasslabel', 'local_mb2builder'),
            'desc' => get_string('customclassdesc', 'local_mb2builder'),
            'default' => '',
        ],
    ],
];

define('LOCAL_MB2BUILDER_SETTINGS_ROW', base64_encode(json_encode($mb2settingsrow)));
