<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_mb2nl
 * @copyright 2017 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license   PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();


$mb2settings = [
    'id' => 'listicon',
    'subid' => 'listicon_item',
    'title' => get_string('listicon', 'local_mb2builder'),
    'icon' => 'fa fa-list',
    'type' => 'general',
    'tabs' => [
        'general' => get_string('generaltab', 'local_mb2builder'),
        'typo' => get_string('typotab', 'local_mb2builder'),
        'colors' => get_string('colorstab', 'local_mb2builder'),
        'style' => get_string('styletab', 'local_mb2builder'),
    ],
    'attr' => [
        'horizontal' => [
            'type' => 'buttons',
            'section' => 'general',
            'title' => get_string('display', 'local_mb2builder'),
            'options' => [
                0 => get_string('normal', 'local_mb2builder'),
                1 => get_string('horizontal', 'local_mb2builder'),
                2 => get_string('twocols', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.theme-listicon',
            'class_remove' => 'horizontal0 horizontal1 horizontal2',
            'class_prefix' => 'horizontal',
        ],
        'align' => [
            'type' => 'buttons',
            'showon' => 'horizontal:0|1',
            'section' => 'general',
            'title' => get_string('alignlabel', 'local_mb2builder'),
            'options' => [
                'none' => get_string('none', 'local_mb2builder'),
                'left' => get_string('left', 'local_mb2builder'),
                'right' => get_string('right', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
            ],
            'default' => 'none',
            'action' => 'class',
            'selector' => '.theme-listicon',
            'class_remove' => 'alignnone alignleft alignright aligncenter',
            'class_prefix' => 'align',
        ],
        'space' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('elpacing', 'local_mb2builder', 'rem'),
            'min' => 0,
            'max' => 10,
            'step' => 0.01,
            'default' => .45,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.theme-listicon',
            'style_properity' => '--mb2-pb-listicon-space',
            'style_suffix' => 'rem',
        ],
        'icon' => [
            'type' => 'icon',
            'section' => 'general',
            'title' => get_string('icon', 'local_mb2builder'),
            'action' => 'icon',
            'default' => 'fa fa-check-square-o',
            'selector' => '.iconel i',
            'globalparent' => 1,
        ],
        'isize' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('iconsize', 'local_mb2builder'),
            'min' => 1,
            'max' => 10,
            'step' => 0.01,
            'default' => 2.65,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.theme-listicon',
            'style_properity' => '--mb2-pb-listicon-isize',
            'style_suffix' => 'rem',
        ],
        'fs' => [
            'type' => 'range',
            'section' => 'typo',
            'title' => get_string('fsizerem', 'local_mb2builder'),
            'min' => 1,
            'max' => 10,
            'step' => 0.01,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => '--mb2-pb-listicon-fs',
            'selector' => '.theme-listicon',
            'style_suffix' => 'rem',
        ],
        'fwcls' => [
            'type' => 'buttons',
            'section' => 'typo',
            'title' => get_string('fweight', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'light' => get_string('fwlight', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
                'medium' => get_string('wmedium', 'local_mb2builder'),
                'semibold' => get_string('semibold', 'local_mb2builder'),
                'bold' => get_string('fwbold', 'local_mb2builder'),
            ],
            'default' => 'global',
            'action' => 'class',
            'selector' => '.theme-listicon',
            'class_remove' => 'fwglobal fwlight fwnormal fwmedium fwsemibold fwbold',
            'class_prefix' => 'fw',
        ],
        'iconcolor' => [
            'type' => 'color',
            'section' => 'colors',
            'title' => get_string('iconcolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.iconel',
            'style_properity' => 'color',
            'globalparent' => 1,
        ],
        'textcolor' => [
            'type' => 'color',
            'section' => 'colors',
            'title' => get_string('textcolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.list-text',
            'style_properity' => 'color',
            'globalparent' => 1,
        ],
        'iconbg' => [
            'type' => 'yesno',
            'section' => 'colors',
            'title' => get_string('background', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.theme-listicon',
            'class_remove' => 'iconbg0 iconbg1',
            'class_prefix' => 'iconbg',
        ],
        'bgcolor' => [
            'type' => 'color',
            'showon' => 'iconbg:1',
            'section' => 'colors',
            'title' => get_string('bgcolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.iconel',
            'style_properity' => 'background-color',
            'globalparent' => 1,
        ],
        'border' => [
            'type' => 'yesno',
            'section' => 'colors',
            'title' => get_string('border', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.theme-listicon',
            'class_remove' => 'border0 border1',
            'class_prefix' => 'border',
        ],
        'borderw' => [
            'type' => 'range',
            'section' => 'colors',
            'showon' => 'border:1',
            'title' => get_string('borderw', 'local_mb2builder'),
            'min' => 1,
            'max' => 5,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.list-text',
            'style_properity' => 'border-bottom-width',
        ],
        'bordercolor' => [
            'type' => 'color',
            'showon' => 'border:1',
            'section' => 'colors',
            'title' => get_string('bordercolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.list-text',
            'style_properity' => 'border-bottom-color',
            'globalparent' => 1,
        ],
        'mt' => [
            'type' => 'range',
            'section' => 'style',
            'title' => get_string('mt', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => 'margin-top',
        ],
        'mb' => [
            'type' => 'range',
            'section' => 'style',
            'title' => get_string('mb', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 30,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => 'margin-bottom',
        ],
        'custom_class' => [
            'type' => 'text',
            'section' => 'style',
            'title' => get_string('customclasslabel', 'local_mb2builder'),
            'desc' => get_string('customclassdesc', 'local_mb2builder'),
            'default' => '',
        ],
    ],
    'subelement' => [
        'tabs' => [
            'general' => get_string('generaltab', 'local_mb2builder'),
        ],
        'attr' => [
            'text' => [
                'type' => 'textarea',
                'section' => 'general',
                'title' => get_string('text', 'local_mb2builder'),
                'action' => 'text',
                'default' => 'List content here.',
                'selector' => '.list-text',
            ],
            'icon' => [
                'type' => 'icon',
                'section' => 'general',
                'title' => get_string('icon', 'local_mb2builder'),
                'action' => 'icon',
                'default' => '',
                'selector' => '.iconel i',
                'globalchild' => 1,
            ],
            'iconcolor' => [
                'type' => 'color',
                'section' => 'general',
                'title' => get_string('color', 'local_mb2builder'),
                'action' => 'color',
                'selector' => '.iconel',
                'style_properity' => 'color',
                'globalchild' => 1,
            ],
            'textcolor' => [
                'type' => 'color',
                'section' => 'general',
                'title' => get_string('textcolor', 'local_mb2builder'),
                'action' => 'color',
                'selector' => '.list-text',
                'style_properity' => 'color',
                'globalchild' => 1,
            ],
            'bgcolor' => [
                'type' => 'color',
                'showon2' => 'iconbg:1',
                'section' => 'general',
                'title' => get_string('bgcolor', 'local_mb2builder'),
                'action' => 'color',
                'selector' => '.iconel',
                'style_properity' => 'background-color',
                'globalchild' => 1,
            ],
            'bordercolor' => [
                'type' => 'color',
                'showon2' => 'border:1',
                'section' => 'general',
                'title' => get_string('bordercolor', 'local_mb2builder'),
                'action' => 'color',
                'selector' => '.list-text',
                'style_properity' => 'border-bottom-color',
                'globalchild' => 1,
            ],
            'link' => [
                'type' => 'text',
                'section' => 'general',
                'title' => get_string('link', 'local_mb2builder'),
            ],
            'link_target' => [
                'type' => 'yesno',
                'section' => 'general',
                'title' => get_string('linknewwindow', 'local_mb2builder'),
                'options' => [
                    1 => get_string('yes', 'local_mb2builder'),
                    0 => get_string('no', 'local_mb2builder'),
                ],
                'action' => 'none',
                'default' => 0,
            ],
        ],
    ],
];

define('LOCAL_MB2BUILDER_SETTINGS_LISTICON', base64_encode(json_encode($mb2settings)));
