<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_mb2nl
 * @copyright 2017 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license   PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();

$mb2settings = [
    'id' => 'banner',
    'subid' => '',
    'title' => get_string('banner', 'local_mb2builder'),
    'icon' => 'ri-rectangle-line',
    'tabs' => [
        'general' => get_string('generaltab', 'local_mb2builder'),
        'title' => get_string('title', 'local_mb2builder'),
        'text' => get_string('text', 'local_mb2builder'),
        'image' => get_string('image', 'local_mb2builder'),
        'button' => get_string('button', 'local_mb2builder'),
        'style' => get_string('styletab', 'local_mb2builder'),
    ],
    'attr' => [
        'title' => [
            'type' => 'text',
            'section' => 'general',
            'title' => get_string('title', 'local_mb2builder'),
            'action' => 'text',
            'selector' => '.title-text',
        ],
        'iscontent' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('text', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'action' => 'class',
            'default' => 0,
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'iscontent0 iscontent1',
            'class_prefix' => 'iscontent',
        ],
        'content' => [
            'type' => 'editor',
            'showon' => 'iscontent:1',
            'section' => 'general',
            'title' => get_string('text', 'local_mb2builder'),
            'selector' => '.mb2-pb-ba_content',
        ],
        'cwidth' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('cwidth', 'local_mb2builder'),
            'min' => 300,
            'max' => 2000,
            'default' => 450,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-ba_inner',
            'style_properity' => 'max-width',
        ],
        'height' => [
            'type' => 'range',
            'section' => 'general',
            'title' => get_string('height', 'local_mb2builder'),
            'min' => 100,
            'max' => 1000,
            'default' => 350,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-ba',
            'style_properity' => 'min-height',
        ],
        'padding' => [
            'type' => 'buttons',
            'section' => 'general',
            'title' => get_string('padding', 'local_mb2builder', ''),
            'options' => [
                'normal' => get_string('medium', 'local_mb2builder'),
                'lg' => get_string('large', 'local_mb2builder'),
            ],
            'default' => 'normal',
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'paddinglg paddingnormal',
            'class_prefix' => 'padding',
        ],
        'halign' => [
            'type' => 'buttons',
            'section' => 'general',
            'title' => get_string('alignh', 'local_mb2builder'),
            'options' => [
                'start' => get_string('left', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
                'end' => get_string('right', 'local_mb2builder'),
            ],
            'default' => 'start',
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'align-items-start align-items-center align-items-end',
            'class_prefix' => 'align-items-',
        ],
        'rounded' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('rounded', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'rounded0 rounded1',
            'class_prefix' => 'rounded',
        ],
        'shadow' => [
            'type' => 'yesno',
            'section' => 'general',
            'title' => get_string('shadow', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'shadow0 shadow1',
            'class_prefix' => 'shadow',
            'default' => 0,
        ],
        'tcolor' => [
            'type' => 'color',
            'section' => 'title',
            'title' => get_string('titlecolor', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-ba_tcolor',
        ],
        'tfs' => [
            'type' => 'range',
            'section' => 'title',
            'title' => get_string('fsizerem', 'local_mb2builder'),
            'min' => 1,
            'max' => 10,
            'step' => 0.01,
            'default' => 1.4,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.ba_title',
            'style_properity' => 'font-size',
            'style_suffix' => 'rem',
            'numclass' => 1,
            'sizepref' => 'pbtsize',
        ],
        'tfw' => [
            'type' => 'buttons',
            'section' => 'title',
            'title' => get_string('fweight', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'light' => get_string('fwlight', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
                'medium' => get_string('wmedium', 'local_mb2builder'),
                'semibold' => get_string('semibold', 'local_mb2builder'),
                'bold' => get_string('fwbold', 'local_mb2builder'),
            ],
            'default' => 'global',
            'action' => 'class',
            'selector' => '.ba_title',
            'class_remove' => 'fwglobal fwlight fwnormal fwmedium fwsemibold fwbold',
            'class_prefix' => 'fw',
        ],
        'tlh' => [
            'type' => 'buttons',
            'section' => 'title',
            'title' => get_string('lh', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'small' => get_string('wsmall', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
            ],
            'default' => 'global',
            'action' => 'class',
            'selector' => '.ba_title',
            'class_remove' => 'lhglobal lhsmall lhnormal',
            'class_prefix' => 'lh',
        ],
        'color' => [
            'type' => 'color',
            'section' => 'text',
            'title' => get_string('textcolor', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-ba_color',
        ],
        'fs' => [
            'type' => 'range',
            'section' => 'text',
            'title' => get_string('fsizerem', 'local_mb2builder'),
            'min' => 1,
            'max' => 10,
            'step' => 0.01,
            'default' => 1,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-ba_content',
            'style_properity' => 'font-size',
            'style_suffix' => 'rem',
            'numclass' => 1,
            'sizepref' => 'pbtsize',
        ],
        'fw' => [
            'type' => 'buttons',
            'section' => 'text',
            'title' => get_string('fweight', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'light' => get_string('fwlight', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
                'medium' => get_string('wmedium', 'local_mb2builder'),
                'semibold' => get_string('semibold', 'local_mb2builder'),
                'bold' => get_string('fwbold', 'local_mb2builder'),
            ],
            'default' => 'global',
            'action' => 'class',
            'selector' => '.mb2-pb-ba_content',
            'class_remove' => 'fwglobal fwlight fwnormal fwmedium fwsemibold fwbold',
            'class_prefix' => 'fw',
        ],
        'lh' => [
            'type' => 'buttons',
            'section' => 'text',
            'title' => get_string('lh', 'local_mb2builder'),
            'options' => [
                'global' => get_string('global', 'local_mb2builder'),
                'small' => get_string('wsmall', 'local_mb2builder'),
                'medium' => get_string('wmedium', 'local_mb2builder'),
                'normal' => get_string('normal', 'local_mb2builder'),
            ],
            'default' => 'global',
            'action' => 'class',
            'selector' => '.mb2-pb-ba_content',
            'class_remove' => 'lhglobal lhsmall lhmedium lhnormal',
            'class_prefix' => 'lh',
        ],
        'tmt' => [
            'type' => 'range',
            'section' => 'text',
            'title' => get_string('mt', 'local_mb2builder'),
            'min' => 0,
            'max' => 5,
            'step' => 0.01,
            'default' => 1.3,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-ba_content',
            'style_properity' => 'margin-top',
            'style_suffix' => 'rem',
        ],
        'image' => [
            'type' => 'image',
            'section' => 'image',
            'title' => get_string('image', 'local_mb2builder'),
            'action' => 'image',
            'selector' => '.ba_img_img',
        ],
        'imgwidth' => [
            'type' => 'range',
            'section' => 'image',
            'title' => get_string('widthlabel', 'local_mb2builder'),
            'min' => 100,
            'max' => 1000,
            'default' => 350,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.ba_img3',
            'style_properity' => 'width',
        ],
        'imgonsm' => [
            'type' => 'yesno',
            'section' => 'image',
            'title' => get_string('smallscreen', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 1,
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_prefix' => 'imgonsm',
            'class_remove' => 'imgonsm0 imgonsm1',
        ],
        'imgcrop' => [
            'type' => 'yesno',
            'section' => 'image',
            'title' => get_string('imgcrop', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'action' => 'class',
            'default' => 0,
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'imgcrop0 imgcrop1',
            'class_prefix' => 'imgcrop',
        ],
        'imgvalign' => [
            'type' => 'buttons',
            'section' => 'image',
            'title' => get_string('alignv', 'local_mb2builder'),
            'options' => [
                'start' => get_string('top', 'local_mb2builder'),
                'center' => get_string('center', 'local_mb2builder'),
                'end' => get_string('bottom', 'local_mb2builder'),
            ],
            'default' => 'center',
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'imgvalignstart imgvaligncenter imgvalignend',
            'class_prefix' => 'imgvalign',
        ],
        'imgmt' => [
            'type' => 'range',
            'showon' => 'imgvalign:start|end',
            'section' => 'image',
            'title' => get_string('vpospixel', 'local_mb2builder'),
            'min' => -500,
            'max' => 500,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.ba_img3',
            'style_properity' => '--mb2-pb-ba_imgmt',
        ],
        'imgpos' => [
            'type' => 'buttons',
            'section' => 'image',
            'title' => get_string('alignh', 'local_mb2builder'),
            'options' => [
                'left' => get_string('left', 'local_mb2builder'),
                'right' => get_string('right', 'local_mb2builder'),
            ],
            'default' => 'left',
            'action' => 'class',
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'imgpos-left imgpos-right',
            'class_prefix' => 'imgpos-',
        ],
        'imghpos' => [
            'type' => 'range',
            'section' => 'image',
            'title' => get_string('hpos', 'local_mb2builder'),
            'min' => -99,
            'max' => 99,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => '--mb-pb-ba_imghpos',
            'style_suffix' => '%',
        ],
        'linkbtn' => [
            'type' => 'yesno',
            'section' => 'button',
            'title' => get_string('readmorebtn', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'action' => 'class',
            'default' => 0,
            'selector' => '.mb2-pb-ba',
            'class_remove' => 'linkbtn0 linkbtn1',
            'class_prefix' => 'linkbtn',
        ],
        'linktext' => [
            'type' => 'text',
            'section' => 'button',
            'showon' => 'linkbtn:1',
            'title' => get_string('btntext', 'local_mb2builder'),
            'action' => 'text',
            'selector' => '.btn-intext',
            'default' => get_string('readmorefp', 'local_mb2builder'),
        ],
        'link' => [
            'type' => 'text',
            'section' => 'button',
            'showon' => 'linkbtn:1',
            'title' => get_string('link', 'local_mb2builder'),
            'default' => '#',
        ],
        'link_target' => [
            'type' => 'yesno',
            'section' => 'button',
            'showon' => 'linkbtn:1',
            'title' => get_string('linknewwindow', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'action' => 'none',
            'default' => 0,
        ],
        'btnsize' => [
            'type' => 'buttons',
            'section' => 'button',
            'title' => get_string('sizelabel', 'local_mb2builder', ''),
            'options' => [
                'sm' => get_string('small', 'local_mb2builder'),
                'normal' => get_string('medium', 'local_mb2builder'),
                'lg' => get_string('large', 'local_mb2builder'),
                'xlg' => get_string('xlarge', 'local_mb2builder'),
            ],
            'default' => 'normal',
            'action' => 'class',
            'selector' => '.mb2-pb-btn',
            'class_remove' => 'sizesm sizelg sizexlg sizenormal',
            'class_prefix' => 'size',
        ],
        'btnrounded' => [
            'type' => 'buttons',
            'section' => 'button',
            'title' => get_string('rounded', 'local_mb2builder'),
            'options' => [
                0 => get_string('global', 'local_mb2builder'),
                1 => get_string('yes', 'local_mb2builder'),
                -1 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.mb2-pb-btn',
            'class_remove' => 'rounded0 rounded1 rounded-1',
            'class_prefix' => 'rounded',
        ],

        'btnborder' => [
            'type' => 'yesno',
            'section' => 'button',
            'title' => get_string('border', 'local_mb2builder'),
            'options' => [
                1 => get_string('yes', 'local_mb2builder'),
                0 => get_string('no', 'local_mb2builder'),
            ],
            'default' => 0,
            'action' => 'class',
            'selector' => '.mb2-pb-btn',
            'class_remove' => 'btnborder0 btnborder1',
            'class_prefix' => 'btnborder',
        ],
        'btnmt' => [
            'type' => 'range',
            'section' => 'button',
            'title' => get_string('mt', 'local_mb2builder'),
            'min' => 0,
            'max' => 5,
            'step' => 0.01,
            'default' => 1.3,
            'action' => 'style',
            'changemode' => 'input',
            'selector' => '.mb2-pb-ba_btn',
            'style_properity' => 'margin-top',
            'style_suffix' => 'rem',
        ],
        'group_btn_start_1' => [
        'type' => 'group_start', 'section' => 'button', 'title' => get_string('normal', 'local_mb2builder')], // Group start.
        'btncolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('color', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-color',
        ],

        'btnbgcolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('bgcolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-bgcolor',
        ],

        'btnbocolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('bordercolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-borcolor',
        ],
        'group_btn_end_1' => ['type' => 'group_end', 'section' => 'button'], // Group end.

        'group_btn_start_2' => [
        'type' => 'group_start', 'section' => 'button', 'title' => get_string('hover_active', 'local_mb2builder')], // Group start.
        'btnhcolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('color', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-hcolor',
        ],

        'btnhbgcolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('bgcolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-bghcolor',
        ],

        'btnhbocolor' => [
            'type' => 'color',
            'section' => 'button',
            'title' => get_string('bordercolor', 'local_mb2builder'),
            'action' => 'color',
            'selector' => '.mb2-pb-btn',
            'cssvariable' => '--mb2-pb-btn-borhcolor',
        ],
        'group_btn_end_2' => ['type' => 'group_end', 'section' => 'button'], // Group end.

        'bgcolor' => [
            'type' => 'color',
            'section' => 'style',
            'title' => get_string('bgcolor', 'local_mb2builder'),
            'action' => 'color',
            'style_properity' => '--mb-pb-ba_bgcolor',
        ],
        'bgimage' => [
            'type' => 'image',
            'section' => 'style',
            'title' => get_string('bgimagelabel', 'local_mb2builder'),
            'action' => 'image',
            'selector' => '.mb2-pb-ba',
            'style_properity' => 'background-image',
        ],
        'mt' => [
            'type' => 'range',
            'section' => 'style',
            'title' => get_string('mt', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 0,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => 'margin-top',
        ],
        'mb' => [
            'type' => 'range',
            'section' => 'style',
            'title' => get_string('mb', 'local_mb2builder'),
            'min' => 0,
            'max' => 300,
            'default' => 30,
            'action' => 'style',
            'changemode' => 'input',
            'style_properity' => 'margin-bottom',
        ],
    ],
];

define('LOCAL_MB2BUILDER_SETTINGS_BANNER', base64_encode(json_encode($mb2settings)));
