<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Unilabel type imageboard
 *
 * @package     unilabeltype_imageboard
 * @author      Andreas Schenkel
 * @copyright   Andreas Schenkel {@link https://github.com/andreasschenkel}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

$string['addmoreimages'] = 'Add more images';
$string['alt'] = 'Text for alt attribute of image';
$string['autoscale'] = 'Auto scale';
$string['autoscale_help'] = 'The canvas is automatically scaled to the max width in the course page when using autoscale.<br>It might be cut off to fit the course page when this is deactivated.';
$string['backgroundimage'] = 'Backgroundimage';
$string['border'] = 'Border (px)';
$string['borderradius'] = 'Borderradius (px)';
$string['buttonlabelhelpergridhide'] = 'Hide Grid';
$string['buttonlabelhelpergridshow'] = 'Show Grid';
$string['buttonlabelresize'] = 'Resize to fit';
$string['canvasheight'] = 'Canvas height';
$string['canvaswidth'] = 'Canvas width';
$string['default_bordercolor'] = 'Default bordercolor';
$string['default_bordercolor_desc'] = 'Default bordercolor of images';
$string['default_borderradius'] = 'Default borderradius (px) of images';
$string['default_borderradius_desc'] = 'Defines the borderradius (px) of images on an imageboard.';
$string['default_bordersize'] = 'Default border size (px) of images';
$string['default_bordersize_desc'] = 'Defines the default size (px) of images on an imageboard.';
$string['default_canvasheight'] = 'Default canvas height';
$string['default_canvasheight_help'] = 'This is the default height of canvas when no backgroundimage is used.';
$string['default_canvaswidth'] = 'Default canvas width';
$string['default_canvaswidth_help'] = 'This is the default canvas width when adding an imageboard.';
$string['default_fontsize'] = 'Default fontsize';
$string['default_fontsize_help'] = 'Default fontsize of an image title';
$string['default_gridcolor'] = 'Default grid color';
$string['default_gridcolor_desc'] = 'Default color of a grid that is shown to teacher for help positioning the images.';
$string['default_height'] = 'Default height';
$string['default_showintro'] = 'Default show unilabel text';
$string['default_titlebackgroundcolor'] = 'Default title backgroundcolor';
$string['default_titlebackgroundcolor_desc'] = 'Default backgroundcolor of imagetitle if imagetitle is not empty';
$string['default_titlecolor'] = 'Default title color';
$string['default_titlecolor_desc'] = 'Default title color of imagetitle';
$string['default_titlelineheight'] = 'Default titlelineheight (em)';
$string['default_titlelineheight_help'] = 'By default this is the lineheight in em so lineheight depends on fontsize.';
$string['edit_info'] = 'You can use this type to arrange graphics on a canvas.<br>After saving, you can add elements using the "Edit content" button.';
$string['fontsize_help'] = 'Fontsize of imagetitle';
$string['height_help'] = 'Use the fixed height option if your pictures have different sizes. This scales all images to the same height. You can also use "auto height" if your pictures have the same height.';
$string['image'] = 'Image';
$string['imagelist'] = 'Imagelist';
$string['imagenr'] = 'Image {$a}';
$string['images'] = 'Images';
$string['nocontent'] = 'No content';
$string['placeholder_targetheight'] = 'Height';
$string['placeholder_targetwidth'] = 'Width';
$string['placeholder_xposition'] = 'X';
$string['placeholder_yposition'] = 'Y';
$string['pluginname'] = 'Imageboard';
$string['pluginname_help'] = 'This plugin type creates an imageboard consisting of a canvas where pictures can be placed in different positions. A click on the image brings the user to a defined url.';
$string['position'] = 'Upper left corner:';
$string['position_help'] = 'All images will have the upper left corner at coordinate (0/0) by default. Images can be moved with this input fields.';
$string['privacy:metadata'] = 'The unilabel type Imageboard does not store any personal data.';
$string['showunilabeltext'] = 'Show unilabel text';
$string['snap'] = 'Snap';
$string['targetheight'] = 'Height=';
$string['targetheight_help'] = 'Different values than 0 will be used. The original imagesize will be used if both values are 0.';
$string['targetsize'] = 'Width/height of the image';
$string['targetsize_help'] = 'Different values than 0 will be used. The original imagesize will be used if both values are 0.';
$string['targetwidth'] = 'Width=';
$string['title'] = 'Title';
$string['titlebackgroundcolor'] = 'Backround color of title';
$string['titlecolor'] = 'Color of title';
$string['titlelineheight'] = 'Lineheight of imagetitle';
$string['titlelineheight_help'] = 'Lineheight in em';
$string['url'] = 'Url';
$string['url_help'] = 'The image becomes a clickable button linked to the defined url by defining an url.';
$string['urltitle'] = 'Url title';
$string['xposition'] = 'X';
$string['yposition'] = 'Y';
