/**
 * JS Canvas
 *
 * Tested in Moodle 3.9
 *
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 * @copyright 2018 MFreak.nl
 * @author    Luuk Verhoeven
 **/
define("mod_gcanvas/canvas",["jquery","core/notification","mod_gcanvas/spectrum"],(function($,notification){var opts={id:0,debugjs:!1,hasHorizontalRuler:!0,background:""},debug={},bufferStep=0,bufferActive=!0,canvas=null,canvasModule={canvasWidth:800,canvasHeight:500,defaultShaperect:{width:70,height:70,left:200,top:50,angle:0,fill:"#ffb628"},defaultShapecircle:{radius:40,left:200,top:50,fill:"#b3cc2b"},defaultShapetriangle:{top:50,left:200,width:70,height:70,fill:"#0081b4"},defaultShapetextbox:{top:50,left:200,fill:"#0081b4"},loadHistory:function(){$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"load_history",data:JSON.stringify({id:opts.id})},dataType:"json",success:function(response){debug.log(response),response.success&&$("#history").html(response.html)},error:function(response){debug.error(response.responseText),notification.addNotification({message:response.responseText,type:"error"})}})},saveCanvasAjax:function(){fabric.Canvas.supports("toDataURL")?$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"save_canvas",data:JSON.stringify({id:opts.id,status:"final",canvas_data:canvas.toDataURL({multiplier:1,format:"png"}),json_data:JSON.stringify(canvas)})},dataType:"json",success:function(response){debug.log(response),response.success?(notification.addNotification({message:M.util.get_string("javascript:updated","mod_gcanvas"),type:"success"}),canvasModule.loadHistory()):notification.addNotification({message:response.error,type:"error"})},error:function(response){debug.error(response.responseText),notification.addNotification({message:response.responseText,type:"error"})}}):notification.addNotification({message:"This browser doesn't provide means to serialize canvas to an image",type:"error"})},deleteSelectedCanvasItems:function(){try{var activeobjects=canvas.getActiveObjects();if(activeobjects.length<=0)return void debug.log("Selection empty");for(var i in activeobjects)if(activeobjects.hasOwnProperty(i)){var element=activeobjects[i];if(void 0!==element.id&&"ruler"===element.id){debug.log("Ruler: Not removable!");continue}canvas.remove(element)}canvas.discardActiveObject().renderAll()}catch(e){debug.error("Nothing selected",e)}},loadDynamicToolbarMappingShapes:function(){$("#toolbar .icon[data-element-type]").on("click",(function(){var el,elementtype=$(this).data("element-type");try{canvas.discardActiveObject()}catch(e){}var shape="defaultShape"+elementtype.toLowerCase();debug.log("Search for shape: "+shape),canvasModule.hasOwnProperty(shape)?(debug.log("Shape found"),el="Textbox"===elementtype?new fabric[elementtype]("DEMO",canvasModule[shape]):new fabric[elementtype](canvasModule[shape]),canvas.add(el),canvas.setActiveObject(el)):debug.error("Shape not found!"),canvas.renderAll()}))},loadColorPicker:function(){$("#colorpicker").spectrum({showPalette:!0,palette:[],showSelectionPalette:!0,selectionPalette:["red","green","blue","orange"],flat:!1,change:function(color){debug.log("change color"),canvasModule.setColor(color)}}).on("dragstart.spectrum , dragstop.spectrum",(function(e,color){debug.log("change color - dragstop - dragstart"),canvasModule.setColor(color)}))},loadEmojiCsv:function(src){debug.log("loadEmojiCsv : ",src),fabric.Image.fromURL(src.replace(".png",".svg"),(function(object){object.set({height:500,width:500,left:150,top:100,angle:0,centerTransform:!0}).scale(.4).setCoords(),canvas.add(object),canvas.setActiveObject(object)}))},deleteAttempt:function($el){debug.log("Delete",$el),notification.confirm(M.util.get_string("javascript:confirm_title","mod_gcanvas"),M.util.get_string("javascript:confirm_desc","mod_gcanvas"),M.util.get_string("javascript:yes","mod_gcanvas"),M.util.get_string("javascript:no","mod_gcanvas"),(function(){$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"delete_attempt",data:JSON.stringify({id:opts.id,attempt_id:$el.data("id")})},dataType:"json",success:function(response){debug.log(response),response.success?canvasModule.loadHistory():notification.addNotification({message:response.error,type:"error"})},error:function(response){debug.error(response.responseText),notification.addNotification({message:response.responseText,type:"error"})}})}))},restoreAttempt:function($el){debug.log("Restore",$el),$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"get_attempt",data:JSON.stringify({id:opts.id,attempt_id:$el.data("id")})},dataType:"json",success:function(response){debug.log(response),response.success&&(bufferActive=!1,canvas.loadFromJSON(response.record.json_data,canvas.renderAll.bind(canvas)),setTimeout((function(){bufferActive=!0}),1e3))}})},showFileuploader:function(filearea){$("#canvas-filepicker-form-"+filearea).toggle()},setBackgroundImage:function(){""!==opts.background&&"false"!==opts.background&&fabric.Image.fromURL(opts.background,(function(img){canvas.setBackgroundImage(img,canvas.renderAll.bind(canvas),{scaleX:canvas.width/img.width,scaleY:canvas.height/img.height})}))},addUserImage:function(){var formdata={id:opts.id},inputs=$("#canvas-filepicker-form-student_image form").serializeArray();$.each(inputs,(function(i,input){formdata[input.name]=input.value})),$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"upload_images",data:JSON.stringify(formdata)},dataType:"json",success:function(response){debug.log(response),response.success&&canvasModule.addImageFromUrl(response.image),$("#canvas-filepicker-form-student_image").hide()}})},addImageFromUrl:function(path){fabric.Image.fromURL(path,(function(object){object.set({left:150,top:100,angle:0,centerTransform:!0}).setCoords();var maxwidth=canvas.getWidth()/3;object.width>maxwidth&&object.scaleToWidth(maxwidth),canvas.add(object),canvas.setActiveObject(object)}))},selectToolbarImage:function(){var dialog=$("#image-picker");dialog.is(":visible")?dialog.hide():(dialog.show(),$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"get_toolbar_images",data:JSON.stringify({id:opts.id})},dataType:"json",success:function(response){if(debug.log(response),response.success){var html='<ul class="list-group">';$.each(response.images,(function(i,src){html+='<li class="toolbar-image" rel="'+i+'"><img  alt="" src="'+src+'" class="img-thumbnail"></li>'})),html+="</ul>",dialog.html(html)}}}))},undo:function(){if(0!==bufferStep)try{var data=localStorage.getItem("buffer_"+bufferStep);canvas.loadFromJSON(data,canvas.renderAll.bind(canvas)),localStorage.removeItem("buffer_"+bufferStep),bufferStep--}catch(e){debug.log(e)}},loadToolbar:function(){this.setBackgroundImage(),this.loadDynamicToolbarMappingShapes(),this.loadColorPicker(),$("#clear").on("click",(function(){canvas.clear(),opts.hasHorizontalRuler&&canvasModule.addHorizontalRuler(),canvasModule.setBackgroundImage()})),$("#arrow i").on("click",(function(){canvasModule.loadArrowToCanvas()})),$("#trash i").on("click",(function(){canvasModule.deleteSelectedCanvasItems()})),$("#smiley i").on("click",(function(){canvasModule.loadEmojiPicker()})),$("#undo").on("click",(function(){bufferActive=!1,canvasModule.undo(),setTimeout((function(){bufferActive=!0}),500)})),$("#add-image i").on("click",(function(){canvasModule.showFileuploader("student_image")})),$("#select-a-image i").on("click",(function(){canvasModule.selectToolbarImage()})),$("#image-picker ").on("click","img",(function(){canvasModule.addImageFromUrl($(this).attr("src")),$("#image-picker").hide()})),$("#save-canvas").on("click",(function(){canvasModule.saveCanvasAjax()})),$("#show-help").on("click",(function(){$("#dialog-help").show()})),$("#dialog-help").on("click",(function(){$("#dialog-help").hide()})),$("#history").on("click",".delete",(function(e){e.preventDefault(),canvasModule.deleteAttempt($(this))})).on("click",".restore",(function(e){e.preventDefault(),canvasModule.restoreAttempt($(this))})),$("#emoji-picker").on("click","img",(function(){canvasModule.loadEmojiCsv($(this).attr("src")),$("#emoji-picker").hide()})),$("#change_background").on("click",(function(){canvasModule.showFileuploader("background")})),$("#add_toolbar_images").on("click",(function(){canvasModule.showFileuploader("toolbar_shape")})),$("#canvas-filepicker-form-student_image").on("click","#id_submitbutton",(function(e){e.preventDefault(),canvasModule.addUserImage()})),$(".dialog").on("click",".btn-secondary",(function(e){e.preventDefault(),debug.log("Cancel"),$(".dialog").hide()}))},loadEmojiPicker:function(){var $picker=$("#emoji-picker");if(""!==$picker.html())return debug.log("Toggle emoji"),void $picker.toggle();$.ajax({type:"POST",url:M.cfg.wwwroot+"/mod/gcanvas/ajax.php",data:{sesskey:M.cfg.sesskey,action:"emoji",data:JSON.stringify({id:opts.id})},dataType:"json",success:function(response){debug.log(response),response.success&&$picker.html(response.html).show()}})},loadArrowToCanvas:function(){fabric.loadSVGFromURL("pix/arrow.svg",(function(objects,options){var obj=fabric.util.groupSVGElements(objects,options);canvas.add(obj.scale(.1)).centerObject(obj).renderAll(),obj.setCoords(),canvas.setActiveObject(obj)}))},setColor:function(color){var colorhex=color.toHexString(),activeobjects=canvas.getActiveObjects();if(activeobjects){for(var i in activeobjects)if(activeobjects.hasOwnProperty(i)){var element=activeobjects[i];if(element.hasOwnProperty("id")&&"ruler"===element.id)continue;element.set("fill",colorhex)}canvas.renderAll()}else debug.log("No active items")},preventMovingOutOfCanvas:function(){canvas.on("object:moving",(function(e){var obj=e.target;obj.currentHeight>obj.canvas.height||obj.currentWidth>obj.canvas.width||(obj.setCoords(),(obj.getBoundingRect().top<0||obj.getBoundingRect().left<0)&&(obj.top=Math.max(obj.top,obj.top-obj.getBoundingRect().top),obj.left=Math.max(obj.left,obj.left-obj.getBoundingRect().left)),(obj.getBoundingRect().top+obj.getBoundingRect().height>obj.canvas.height||obj.getBoundingRect().left+obj.getBoundingRect().width>obj.canvas.width)&&(obj.top=Math.min(obj.top,obj.canvas.height-obj.getBoundingRect().height+obj.top-obj.getBoundingRect().top),obj.left=Math.min(obj.left,obj.canvas.width-obj.getBoundingRect().width+obj.left-obj.getBoundingRect().left)))}))},keyboardActions:function(){$(document).keydown((function(e){if(debug.log("keypress",e.which),46===e.which)canvasModule.deleteSelectedCanvasItems()}))},init:function(){this.__canvas=canvas=new fabric.Canvas("sketch"),$("body").on("contextmenu","canvas , img",(function(){return!1})),canvas.setHeight(this.canvasHeight),canvas.setWidth(this.canvasWidth-70),canvas.on({"selection:created":this.onchange,"selection:updated":this.onchange,"object:added":this.addToCache,"object:removed":this.addToCache,"object:modified":this.addToCache}),localStorage.clear(),this.preventMovingOutOfCanvas(),this.loadToolbar(),opts.hasHorizontalRuler&&this.addHorizontalRuler(),this.loadHistory(),this.keyboardActions()},addToCache:function(){debug.log("history"),canvasModule.addCanvasToCacheBuffer()},addCanvasToCacheBuffer:function(){bufferActive&&(clearTimeout(0),setTimeout((function(){try{bufferStep++,localStorage.setItem("buffer_"+bufferStep,JSON.stringify(canvas))}catch(e){debug.log(e)}}),500))},addHorizontalRuler:function(){var ruler=new fabric.Rect({width:this.canvasWidth,height:2,id:"ruler",left:0,top:410,angle:0,fill:"#8b58a1"});ruler.flipY=!1,ruler.lockMovementX=!0,ruler.lockScalingX=!0,ruler.lockScalingY=!0,ruler.lockUniScaling=!0,ruler.lockRotation=!0,canvas.add(ruler),canvas.renderAll(),$(document).keydown((function(e){switch(e.which){case 38:ruler.top=ruler.top-10,canvas.renderAll();break;case 40:ruler.top=ruler.top+10,canvas.renderAll();break;default:return}e.preventDefault()}))},onchange:function(options){options.target.hasOwnProperty("id")&&"ruler"===options.target.id||$("#colorpicker").spectrum("set",options.target.fill)}};return{initialise:function(args){!function(options){var key,vartype;for(key in opts)opts.hasOwnProperty(key)&&options.hasOwnProperty(key)&&("boolean"==(vartype=typeof opts[key])?opts[key]=Boolean(options[key]):"number"===vartype?opts[key]=Number(options[key]):"string"===vartype&&(opts[key]=String(options[key])))}(args),function(isenabled){if(isenabled)for(var m in console)"function"==typeof console[m]&&(debug[m]=console[m].bind(window.console));else for(var i in console)"function"==typeof console[i]&&(debug[i]=function(){})}(opts.debugjs),$.noConflict(),$(document).ready((function(){debug.log("Canvas Module v1.2"),canvasModule.init()}))}}}));

//# sourceMappingURL=canvas.min.js.map