<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    local_mb2builder
 * @copyright  2018 - 2025 Mariusz Boloz (lmsstyle.com)
 * @license    PHP and HTML: http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later. Other parts: http://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();

$string['accentcolor'] = 'Accent color';
$string['accordion'] = 'Accordion';
$string['accordion_item'] = 'Accordion item';
$string['accordionimg'] = 'Accordion image';
$string['accordionimg_item'] = 'Accordion image item';
$string['accordionopen'] = 'Show panel #';
$string['accordionparent'] = 'Close other panels when current panel is open';
$string['acolor'] = 'After-text color';
$string['action'] = 'Action';
$string['active'] = 'Active';
$string['active1item'] = 'Open first item';
$string['addelement'] = 'Add element';
$string['addfooter'] = 'New footer';
$string['addpage'] = 'Add page';
$string['addpart'] = 'New content part';
$string['addrow'] = 'Add row';
$string['addsection'] = 'Add section';
$string['adminlabeldesc'] = 'Enter admin label of this element for easy identification.';
$string['adminlabellabel'] = 'Admin label';
$string['afwcls'] = 'After-text font weight';
$string['alert'] = 'Alert';
$string['aligncolumn'] = 'Align column';
$string['alignh'] = 'Horizontal align';
$string['alignlabel'] = 'Align';
$string['aligntext'] = 'Align text';
$string['alignv'] = 'Vertical align';
$string['all'] = 'All';
$string['alttext'] = 'Alternative text';
$string['angle'] = 'Angle';
$string['animation'] = 'Animation';
$string['animnum'] = 'Animated number';
$string['animnum_item'] = 'Animated number item';
$string['animtype'] = 'Animation effect';
$string['announcements'] = 'Deprecated';
$string['arrowbtn'] = 'Arrow link';
$string['aspeed'] = 'Animation speed (ms)';
$string['atext'] = 'Text after';
$string['attrname'] = 'Attribute name';
$string['attrval'] = 'Attribute value';
$string['author'] = 'Author';
$string['autobackup'] = 'Automated backup';
$string['automatic'] = 'Automatic';
$string['autoplay'] = 'Auto play';
$string['backdelay'] = 'Time before backspacing (ms)';
$string['background'] = 'Background';
$string['backspeed'] = 'Backspacing speed (ms)';
$string['backup'] = 'Backup';
$string['backupcorrupted'] = 'The backup file is not valid or corrupted: {$a}';
$string['backupcreated'] = 'Backup created';
$string['backupdeleted'] = 'Backup deleted';
$string['backupexists'] = 'Backup already exists: {$a}';
$string['backupname'] = 'Backup name';
$string['backupnum'] = 'Number of backups to retain';
$string['backups'] = 'Backups';
$string['backupvalid'] = 'The backup file is valid: {$a}';
$string['badge'] = 'Badge';
$string['badgetext'] = 'Badge text';
$string['banner'] = 'Banner';
$string['bcolor'] = 'Before-text color';
$string['bestseller'] = 'Bestseller';
$string['bfwcls'] = 'Before-text font weight';
$string['bgcolor'] = 'Background color';
$string['bgelements'] = 'Background elements';
$string['bgfixed'] = 'Fixed background';
$string['bgimage'] = 'Background image';
$string['bgimagelabel'] = 'Background image';
$string['bgtext'] = 'Text';
$string['bgvideo'] = 'Background video';
$string['blog'] = 'Blog';
$string['blogitemdate'] = '%d %b %Y';
$string['blurbg'] = 'Blur effect';
$string['border'] = 'Border';
$string['borderb'] = 'Border bottom';
$string['bordercolor'] = 'Border color';
$string['bordert'] = 'Border top';
$string['borderw'] = 'Border width';
$string['bottom'] = 'Bottom';
$string['box'] = 'Box';
$string['boxes3d'] = 'Boxes - 3D';
$string['boxes3d_item'] = 'Box 3D';
$string['boxescircle'] = 'Boxes - circle';
$string['boxescircle_item'] = 'Boxe circle';
$string['boxescontent'] = 'Boxes - content';
$string['boxescontent_item'] = 'Box content';
$string['boxesicon'] = 'Boxes - icon';
$string['boxesicon_item'] = 'Box icon';
$string['boxesimg'] = 'Boxes - image';
$string['boxesimg_item'] = 'Box image';
$string['boxmb'] = 'Box margin bottom';
$string['btext'] = 'Text before';
$string['btntext'] = 'Button text';
$string['buildepage'] = 'Build this page';
$string['buildepagemoodle'] = 'Edit this page in Moodle';
$string['builder'] = 'Builder';
$string['builderarea'] = 'Builder area {$a->id}';
$string['builderfooter'] = 'Footer builder';
$string['builderfp'] = 'Deprecated';
$string['button'] = 'Button';
$string['cachedef_builder'] = 'Mb2 Builder elements cache';
$string['cachedef_footerdata'] = 'Mb2 Builder footer data cache';
$string['cachedef_pagedata'] = 'Mb2 Builder page data cache';
$string['cachedef_pages'] = 'Mb2 Builder pages ids and mpages cache';
$string['cachedef_partdata'] = 'Mb2 Builder content parts data cache';
$string['callaccessible'] = 'All accessible courses';
$string['cannoteditpart'] = 'You can\'t edit content part: [mb2part id="{$a}"].';
$string['cannotremove'] = 'This element can\'t be removed.';
$string['cantopenmodal'] = 'You can\'t open two modal windows.';
$string['caption'] = 'Caption';
$string['carousel'] = 'Carousel';
$string['carousel_item'] = 'Carousel item';
$string['carouselitems'] = 'Carousel items';
$string['carouseltab'] = 'Carousel';
$string['catdesc'] = 'Category description';
$string['categories'] = 'Categories';
$string['category'] = 'Category:';
$string['catidsdesc'] = 'Comma separated category IDs.';
$string['catidslabel'] = 'Category IDs';
$string['ccolor'] = 'Custom color';
$string['center'] = 'Center';
$string['choosecontext'] = 'Choose course or category...';
$string['chooseitem'] = 'Choose item...';
$string['chooselayout'] = 'Chose custom layout';
$string['cids'] = 'Course IDs';
$string['cidsdesc'] = 'Comma separated course IDs.';
$string['circle'] = 'Circle';
$string['close'] = 'Close';
$string['closebtn'] = 'Close button';
$string['code'] = 'Code';
$string['color'] = 'Color';
$string['colors'] = 'Custom colors';
$string['colorsdesc'] = 'Set custom colors for items. Use "item_id:color_value" (hex or rgb). For more items add comma separator, for example I have four items with the following ids: 1, 2, 3, 15 and I want to set custom colors for these items:<br><pre>1:#0000cc,2:#009933,3:#993333,15:#cc9933</pre>';
$string['colorstab'] = 'Colors';
$string['colspace'] = 'Column gutter';
$string['column'] = 'Column';
$string['columns'] = 'Columns';
$string['columnscarousel'] = 'Columns or carousel';
$string['companyname'] = 'Company name';
$string['confirmdeletebackup'] = 'Do you really want to delete the backup: <strong>{$a->title}</strong>?';
$string['confirmdeletebackupjs'] = 'Do you really want to delete the backup?';
$string['confirmdeletefooter'] = 'Do you really want to delete footer: <strong>{$a->title}</strong>?';
$string['confirmdeletelayout'] = 'Do you really want to delete layout: <strong>{$a->title}</strong>?';
$string['confirmdeletepage'] = 'Do you really want to delete page: <strong>{$a->title}</strong>?';
$string['confirmdeletepart'] = 'Do you really want to delete part: <strong>{$a->title}</strong>?';
$string['confirmreplacecontent'] = 'Are you sure you want to replace content?';
$string['content'] = 'Content';
$string['contentnav'] = 'Navigation in description';
$string['copied'] = 'Copied';
$string['copy'] = 'Copy';
$string['copycode'] = 'Copy code';
$string['coursecount'] = 'Course count';
$string['courseprices'] = 'Deprecated';
$string['coursepricesdesc'] = 'Deprecated';
$string['courses'] = 'Courses';
$string['coursescount'] = 'Courses in category';
$string['coursesperpage'] = 'Courses per tab';
$string['coursestartdate'] = 'Deprecated';
$string['coursestudentscount'] = 'Students';
$string['coursetabs'] = 'Course tabs';
$string['coursinstructor'] = 'Instructor';
$string['create'] = 'Create';
$string['createdby'] = 'Created by';
$string['createnewbackup'] = 'Create new backup';
$string['creative'] = 'Creative';
$string['cstyle'] = 'Course style';
$string['currency'] = 'Deprecated';
$string['custom'] = 'Custom';
$string['customclassdesc'] = 'Use this field to add a custom css class and then refer to it in your css style.';
$string['customclasslabel'] = 'Custom css class';
$string['customimages'] = 'Item media';
$string['customize'] = 'Customize page';
$string['customvideolabel'] = 'Custom video';
$string['cwidth'] = 'Content width';
$string['danger'] = 'Danger';
$string['dark'] = 'Dark';
$string['dark_striped'] = 'Dark striped';
$string['dashed'] = 'Dashed';
$string['date'] = 'Date';
$string['default'] = 'Default';
$string['deletebackup'] = 'Delete backup';
$string['deletefooter'] = 'Delete footer';
$string['deletelayout'] = 'Delete layout';
$string['deletepage'] = 'Delete page';
$string['deletepart'] = 'Delete part';
$string['desc'] = 'Description';
$string['desclimit'] = 'Description words limit';
$string['dirnav'] = 'Prev next navigation';
$string['disc'] = 'Disc';
$string['display'] = 'Display';
$string['dotted'] = 'Dotted';
$string['double'] = 'Double';
$string['downloadcontent'] = 'Export page content';
$string['downloadcontent1'] = 'Deprecated';
$string['downloadcontent2'] = 'Deprecated';
$string['duplicate'] = 'Duplicate';
$string['editfooter'] = 'Edit footer';
$string['editlayout'] = 'Edit layout';
$string['editpage'] = 'Edit page';
$string['editpart'] = 'Edit content part';
$string['elaccesguests'] = 'Guests';
$string['elaccess'] = 'Who can see this section/row?';
$string['elaccessall'] = 'Everyone';
$string['elaccessusers'] = 'Logged in users';
$string['elboxes3d'] = 'Boxes - 3D';
$string['elboxescontent'] = 'Boxes content';
$string['elboxesicon'] = 'Boxes - icon';
$string['elboxesimg'] = 'Boxes - image';
$string['elcode'] = 'Code';
$string['element'] = 'Element';
$string['elheading'] = 'Heading';
$string['elpacing'] = 'Space between items ({$a})';
$string['eltext'] = 'Text';
$string['emptydata'] = 'No data found';
$string['events'] = 'Events';
$string['exclude'] = 'Exclude';
$string['export'] = 'Export layout';
$string['fade'] = 'Fade';
$string['filesize'] = 'File size';
$string['filtertype'] = 'Filter type';
$string['flip_hor'] = 'Flip horizontal';
$string['flip_ver'] = 'Flip vertical';
$string['fliph'] = 'Flip horizontally';
$string['footer'] = 'Footer';
$string['footerdeleted'] = 'Footer deleted.';
$string['footernoexists'] = 'Footer (mb2footer) with ID: {$a->id} does not exist.';
$string['footers'] = 'Footers';
$string['footertools'] = 'Footer tools';
$string['footerupdated'] = 'Footer updated: <strong>{$a->title}</strong>';
$string['fsitalic'] = 'Italic';
$string['fsizerem'] = 'Font size';
$string['fstyle'] = 'Font style';
$string['fullwidth'] = 'Full width';
$string['fwbold'] = 'Bold';
$string['fweight'] = 'Font weight';
$string['fwlight'] = 'Light';
$string['generaltab'] = 'General';
$string['global'] = 'Global';
$string['globalimages'] = 'Global media';
$string['globalsearch'] = 'Global search';
$string['gotopage'] = 'Go to page';
$string['gradcolorn'] = 'Gradient color {$a->n}';
$string['gradient'] = 'Gradient';
$string['gradient20'] = 'Gradient 20';
$string['gradient40'] = 'Gradient 40';
$string['gradloc1'] = 'Gradient start';
$string['gradloc2'] = 'Gradient end';
$string['gray'] = 'Gray';
$string['grayscale'] = 'Grayscale';
$string['grdwidth'] = 'Grid width';
$string['hbgcolor'] = 'Hover background color';
$string['hcolor'] = 'Hover color';
$string['header'] = 'Header';
$string['headerstyle'] = 'Header style';
$string['heading'] = 'Heading';
$string['height'] = 'Height';
$string['hero'] = 'Hero';
$string['herogradl'] = 'Gradient left';
$string['herogradr'] = 'Gradient right';
$string['heroimg'] = 'Hero image';
$string['hidden'] = 'Hidden';
$string['horizontal'] = 'Horizontal';
$string['hover_active'] = 'Hover/focus/active';
$string['hpos'] = 'Horizontal position';
$string['hspace'] = 'Horizontal space';
$string['html'] = 'HTML';
$string['htmlerror'] = 'Invalid HTML.';
$string['htmltag'] = 'HTML tag';
$string['iafter'] = 'Icon after text';
$string['icon'] = 'Icon';
$string['icon2'] = 'Icon';
$string['iconboxes'] = 'Icon boxes';
$string['iconcolor'] = 'Icon color';
$string['iconposh'] = 'Icon horizontal position';
$string['iconposv'] = 'Icon vertical position';
$string['icons'] = 'Icons';
$string['iconsize'] = 'Icon size';
$string['iframe'] = 'Embed content';
$string['image'] = 'Image';
$string['imageboxes'] = 'Image boxes';
$string['images'] = 'Media';
$string['imgcrop'] = 'Crop image';
$string['imgdescription'] = 'Image description';
$string['imgh'] = 'Height based on image';
$string['imgnoticespace'] = 'Image name \'{$a->img}\' contains space.';
$string['imgwidth'] = 'Image width';
$string['import'] = 'Import custom layout';
$string['importexport'] = 'Import/Export';
$string['importkeep'] = 'Keep current content';
$string['importlabel'] = 'Insert valid JSON string';
$string['importlayoutbtn'] = 'Import layout';
$string['importrows'] = 'Blocks';
$string['importsuccess'] = 'Import done. Click \'Save changes\' button to keep changes.';
$string['importtextempty'] = 'Import field is empty.';
$string['importtextnotvalidjson'] = 'Imported content is not a valid JSON object.';
$string['include'] = 'Include';
$string['info'] = 'Info';
$string['inverse'] = 'Inverse';
$string['item'] = 'item';
$string['itemdate'] = 'Show item date';
$string['itemsperpage'] = 'Items per page';
$string['job'] = 'Job';
$string['label'] = 'Label';
$string['labelpos'] = 'Label position';
$string['languagedesc'] = 'Type a language code or comma-separated list of codes for displaying the section/row to users of the specified language only.';
$string['languages'] = 'Languages';
$string['large'] = 'L';
$string['layoutcreated'] = 'Layout saved';
$string['layoutdeleted'] = 'Layout deleted.';
$string['layoutimported'] = 'Layout imported';
$string['layouts'] = 'Layouts';
$string['layoutscustom'] = 'Custom layouts';
$string['layouttab'] = 'Layout';
$string['layoutupdated'] = 'Layout updated: <strong>{$a->title}</strong>';
$string['left'] = 'Left';
$string['lh'] = 'Line height';
$string['light'] = 'Light';
$string['light_striped'] = 'Light striped';
$string['line'] = 'Line';
$string['link'] = 'Link';
$string['linknewwindow'] = 'Open link in a new window';
$string['linktarget'] = 'Open link';
$string['linktargetblank'] = 'In a new window';
$string['linktargetself'] = 'In the same window';
$string['list'] = 'List';
$string['list_item'] = 'List item';
$string['listicon'] = 'List icon';
$string['listicon_item'] = 'List icon item';
$string['login'] = 'Login';
$string['loop'] = 'Animation loop';
$string['lspacing'] = 'Space between characters';
$string['managefooters'] = 'Footers';
$string['managepages'] = 'Pages';
$string['manageparts'] = 'Content parts';
$string['manual'] = 'Manual';
$string['margindesc'] = 'Margin top right bottom left, for example: 10px 15px 30px 15px';
$string['marginlabel'] = 'Margin';
$string['mb'] = 'Margin bottom';
$string['mb2builder:managebackups'] = 'Manage backups';
$string['mb2builder:managefooters'] = 'Manage footers';
$string['mb2builder:managelayouts'] = 'Manage layouts';
$string['mb2builder:managepages'] = 'Manage pages';
$string['mb2builder:manageparts'] = 'Manage content parts';
$string['mb2builder:view'] = "Mb2 front page builder";
$string['mb2builder:viewfooters'] = 'Deprecated';
$string['mb2builder:viewlayouts'] = 'Deprecated';
$string['mb2builder:viewpages'] = 'Deprecated';
$string['mb2dummyimg'] = 'https://dummyimage.com/{$a}';
$string['medium'] = 'M';
$string['menu'] = 'Menu';
$string['mheight'] = 'Height on mobile';
$string['minimal'] = 'Minimal';
$string['minimal_big'] = 'Minimal big';
$string['ml'] = 'Margin left';
$string['mobcenter'] = 'Center content on small screens';
$string['mobcolumns'] = 'Multiple columns on small screens';
$string['moborder'] = 'Order on small screens';
$string['modern'] = 'Modern';
$string['modifiedby'] = 'Modified by';
$string['moodlepage'] = 'Moodle page';
$string['move'] = 'Move';
$string['mr'] = 'Margin right';
$string['msize'] = 'Size on mobile';
$string['mt'] = 'Margin top';
$string['mycourses'] = 'My courses';
$string['name'] = 'Name';
$string['navbg'] = 'Navigation background color';
$string['navw'] = 'Navigation width';
$string['nline'] = 'New line';
$string['no'] = 'No';
$string['nocids'] = 'Course IDs to exclude';
$string['nocourseincategory'] = 'No courses';
$string['nofilter'] = '<div class="filter-message"><p>Everything works great, but one little thing have to be done.</p><p><strong>Mb2 Shortcodes FILTER</strong> plugin must be:</p><ol><li>Installed (<em>Site administration &rarr; Plugins &rarr; Install plugins</em>)</li><li>Activated (<em>Site administration &rarr; Plugins &rarr; Filters &rarr; Manage filters</em>)</li></ol></div>';
$string['none'] = 'None';
$string['nopadding'] = 'No padding';
$string['nopage'] = 'Page doesn\'t exist';
$string['nopartelements'] = 'Elements not available in content parts';
$string['noprice'] = 'Free';
$string['normal'] = 'Normal';
$string['number'] = 'Number';
$string['numcolor'] = 'Number color';
$string['numsize'] = 'Number size';
$string['off'] = 'Off';
$string['on'] = 'On';
$string['onlyfortype'] = 'Only for type {$a->type}';
$string['onmobile'] = 'Show on mobile';
$string['options'] = 'Options';
$string['overcontent'] = ' Over content';
$string['overlaycolor'] = 'Overlay color';
$string['overridelayout'] = 'Replace layout';
$string['padding'] = 'Padding';
$string['page'] = 'Page';
$string['pagecreated'] = 'Page created';
$string['pagecss'] = 'Page css style';
$string['pagedeleted'] = 'Page deleted.';
$string['pagenoexists'] = 'Page (mb2page) with ID: {$a->id} does not exist.';
$string['pagernav'] = 'Pager navigation';
$string['pageupdated'] = 'Page updated: <strong>{$a->title}</strong>';
$string['paragraph'] = 'Paragraph';
$string['parallax'] = 'Parallax scrolling effect';
$string['part'] = 'Content part';
$string['partdeleted'] = 'Part deleted.';
$string['partnoexists'] = 'Content part with ID: {$a->id} does not exist.';
$string['parts'] = 'Content parts';
$string['partupdated'] = 'Part updated: <strong>{$a->title}</strong>';
$string['pblabel'] = 'Padding bottom';
$string['pbmainslider'] = 'Main slider';
$string['pbmainslider_item'] = 'Slider item';
$string['phlabel'] = 'Padding left/right';
$string['pinned'] = 'Pinned items';
$string['placeholder'] = 'Placeholder text';
$string['pllabelrem'] = 'Padding left';
$string['pluginname'] = 'Mb2 Builder';
$string['pluscolor'] = 'Open/close icon color';
$string['position'] = 'Position';
$string['postexternal'] = 'External blogs';
$string['postids'] = 'Post IDs';
$string['postidsdesc'] = 'Comma separated post IDs.';
$string['posts'] = 'Posts';
$string['precolor'] = 'Predefined color';
$string['prestyle'] = 'Predefined style';
$string['price'] = 'Price';
$string['pricetab'] = 'Deprecated';
$string['primary'] = 'Primary';
$string['process'] = 'Process';
$string['process_item'] = 'Process item';
$string['processing'] = 'Processing...';
$string['ptlabel'] = 'Padding top';
$string['pvlabel'] = 'Padding top/bottom';
$string['rating'] = 'Rating';
$string['readmorebtn'] = 'Link button';
$string['readmorefp'] = 'Read more';
$string['refreshtype'] = 'Refresh type animation';
$string['remove'] = 'Remove';
$string['removeformat'] = 'Remove formatting';
$string['requirefield'] = 'This field is required';
$string['resettodefault'] = 'Set default';
$string['restorefromzip'] = 'Restore from ZIP';
$string['reviews'] = 'Reviews';
$string['right'] = 'Right';
$string['rotate'] = 'Rotate {$a->rotate}';
$string['rounded'] = 'Rounded';
$string['row'] = 'Row';
$string['rowheader'] = 'Row header';
$string['rowheaderbig'] = 'Big header';
$string['rowheadercontent'] = 'Row header text';
$string['rowicon'] = 'Row icon';
$string['rowtext'] = 'Row text';
$string['rowvalign'] = 'Center elements vertically';
$string['runanimation'] = 'Run animation';
$string['sampleimages'] = 'Sample media';
$string['sanimate'] = 'Animation time (ms)';
$string['savelayoutbtn'] = 'Save layout';
$string['savelayoutplh'] = 'Layout name...';
$string['scheme'] = 'Color scheme';
$string['school'] = 'School';
$string['script'] = 'Script';
$string['search'] = 'Search';
$string['search:page'] = 'Mb2 Builder - pages';
$string['searchiconfor'] = 'Search icons for...';
$string['searchimagefor'] = 'Search image for...';
$string['secondary'] = 'Secondary';
$string['section'] = 'Section';
$string['select'] = 'Select';
$string['select_item'] = 'Select item';
$string['selectfooter'] = 'Use theme footer';
$string['selectheaderstyle'] = 'Use theme style';
$string['selecticon'] = 'Select icon';
$string['selectimage'] = 'Select media';
$string['selectlayout'] = 'Select layout';
$string['semibold'] = 'Semi-bold';
$string['semitbgcolor'] = 'Semi-transparent color layer over background image';
$string['settings'] = 'Settings';
$string['shadow'] = 'Shadow';
$string['shortcode'] = 'Deprecated';
$string['shortcodereplaced'] = '--- You can\'t use shortcodes inside element ---';
$string['showall'] = 'Show all';
$string['siteevents'] = 'Site events';
$string['sizelabel'] = 'Size{$a}';
$string['slide'] = 'Slide';
$string['slidercolumns'] = 'Carousel columns';
$string['small'] = 'S';
$string['smallscreen'] = 'Show on small screen';
$string['smtitle'] = 'Deprecated';
$string['social'] = 'Social icons';
$string['solid'] = 'Solid';
$string['spausetime'] = 'Pause time (ms)';
$string['spin'] = 'Spin';
$string['square'] = 'Square';
$string['star'] = '{$a} <i class="fa fa-star"></i>';
$string['strftimedatemoncourselist'] = '%d %b';
$string['strftimedatemonthabbr'] = '%d %b %Y';
$string['strip1'] = 'Strip left white';
$string['strip2'] = 'Strip left black';
$string['strip3'] = 'Strip vertical black';
$string['strip4'] = 'Strip vertical white';
$string['studentroleshortname'] = 'Student role shortname';
$string['stylen'] = 'Style {$a->style}';
$string['styletab'] = 'Style';
$string['subelement'] = 'Subelement';
$string['subtext'] = 'Subtext';
$string['subtitle'] = 'Subtitle';
$string['subtitlecolor'] = 'Subtitle color';
$string['success'] = 'Success';
$string['superpost'] = 'Super post';
$string['taball'] = 'All courses tab';
$string['tabpos'] = 'Tabs position';
$string['tabs'] = 'Tabs';
$string['tabs_item'] = 'Tabs item';
$string['tabscenter'] = 'Center tabs';
$string['tagids'] = 'Tag IDs';
$string['tagidsdesc'] = 'Comma separated tag IDs.';
$string['tagidslabel'] = 'Tag IDs';
$string['tags'] = 'Tags';
$string['tcenter'] = 'Center text';
$string['teacherids'] = 'Teacher IDs';
$string['teacheridsdesc'] = 'Comma separated user IDs.';
$string['teacherroleshortname'] = 'Teacher role shortname';
$string['teachers'] = 'Teachers';
$string['testimonials'] = 'Testimonials';
$string['testimonials_item'] = 'Testimonials item';
$string['text'] = 'Text';
$string['textafter'] = 'Text after';
$string['textbefore'] = 'Text before';
$string['textbeforeafter'] = 'Before/after text';
$string['textcolor'] = 'Text color';
$string['tgsdb'] = 'Toggle sidebar';
$string['theme'] = 'Theme';
$string['themesettings'] = 'Use theme settings';
$string['thin'] = 'Thin';
$string['timecreated'] = 'Created on';
$string['timemodified'] = 'Modified on';
$string['title'] = 'Title';
$string['titleandimage'] = 'Title and image';
$string['titlecolor'] = 'Title color';
$string['titlefs'] = 'Title font size';
$string['titlelimit'] = 'Title words limit';
$string['titlesize'] = 'Title size (rem)';
$string['titletext'] = 'Title text';
$string['togglewindowsize'] = 'Toggle window size';
$string['top'] = 'Top';
$string['tshadow'] = 'Text shadow';
$string['tshadowb'] = 'Text shadow blur';
$string['tshadowc'] = 'Text shadow color';
$string['tshadowh'] = 'Text shadow horizontal';
$string['tshadowv'] = 'Text shadow vertical';
$string['twidth'] = 'Title width';
$string['twocols'] = 'Two columns';
$string['type'] = 'Type';
$string['typed'] = 'Type';
$string['typedtext'] = 'Typed text';
$string['typen'] = 'Type {$a->type}';
$string['typespeed'] = 'Type speed (ms)';
$string['typotab'] = 'Typography';
$string['university'] = 'University';
$string['upcomingevents'] = 'Upcoming events';
$string['uploadfile'] = 'Upload file';
$string['uploadimages'] = 'Upload media';
$string['uppercase'] = 'Uppercase';
$string['url'] = 'Url';
$string['urltolink'] = '<div class="filter-message urltolink"><p>One more thing have to be done:</p><ol><li>Go to: <em>Site administration &rarr;  Plugins &rarr; Filters &rarr; Manage filters</em></li><li>Move <strong>Mb2 Shortcodes</strong> filter above <strong>Convert URLs into links and images</strong> filter.</li></ol></div>';
$string['userimg'] = 'User image';
$string['vertical'] = 'Vertical';
$string['vgap'] = 'Vertical gap';
$string['video'] = 'Video';
$string['videofile'] = 'Video file';
$string['videoiddesc'] = 'Paste URL of video which can be embeded, for example Youtube or Vimeo or Aparat (aparat.com).';
$string['videoidlabel'] = 'Web video URL';
$string['videolocal'] = 'Video - local';
$string['videopopup'] = 'Video - popup';
$string['videoweb'] = 'Video - web';
$string['viewall'] = 'View all';
$string['vpospixel'] = 'Vertical position';
$string['vspace'] = 'Vertical space';
$string['warning'] = 'Warning';
$string['wave'] = 'Wave';
$string['wavecolor'] = 'Wave color';
$string['waven'] = 'Wave {$a->n}';
$string['wavetab'] = 'Wave';
$string['wholeitemlink'] = 'Whole item link';
$string['widthlabel'] = 'Width';
$string['wmedium'] = 'Medium';
$string['wsmall'] = 'Small';
$string['wspacing'] = 'Space between words';
$string['xlarge'] = 'XL';
$string['xmoreteachers'] = 'and {$a->teachers} more';
$string['xsmall'] = 'XS';
$string['xxlarge'] = 'XXL';
$string['yes'] = 'Yes';
