// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Filters constants.
 *
 * @module     moodle-block_xp-filters
 * @package    block_xp
 * @copyright  2015 Frédéric Massart
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @main       moodle-block_xp-filters
 */

/**
 * @module moodle-block_xp-filters
 */

var CSS = {
    ADDFILTER: 'filter-add',
    FILTER: 'filter',
    FILTERSLIST: 'filters-list',
    PREFIX: 'block_xp-filters',
    RULE: 'rule',
    RULES: 'rule-rules',
};
var SELECTORS = {
    ADDFILTER: '.filter-add',
    ADDFILTERBTN: '.filter-add a',
    ADDRULE: '.rule-add',
    ADDRULEBTN: '.rule-add a',
    ADDRULEINRULES: '> .rule-add',
    CHILDRULESDEFINITIONS: '.rule-rules .rule-definition',
    CONTAINER: '.block-xp-filters',
    DELETEFILTERBTN: '.filter-delete',
    DELETERULEBTN: '.rule-delete',
    FILTER: '.filter',
    FILTERMOVE: '.filter-move',
    FILTERRULES: '.filter-rules',
    FILTERSLIST: '.filters-list',
    FILTERSLISTNODES: '.filters-list > li',
    RULE: '.rule',
    RULEDEFINITION: '.rule-definition',
    RULEMOVE: '.rule .rule-move',
    RULES: '.rule-rules',
};
