<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace block_xp\local\division;

use block_xp\local\userfilter\nobody;
use block_xp\local\userfilter\user_filter;

/**
 * Division.
 *
 * @package    block_xp
 * @copyright  2024 Frédéric Massart
 * @author     Frédéric Massart <fred@branchup.tech>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class empty_division implements division {

    /**
     * Get the ID.
     *
     * @return string|int
     */
    public function get_id() {
        return 'empty';
    }

    /**
     * Get the name.
     *
     * @return string
     */
    public function get_name(): string {
        return '';
    }

    /**
     * Get the user filter.
     *
     * @return user_filter
     */
    public function get_user_filter(): user_filter {
        return new nobody();
    }

}
