define("block_sharing_cart/script",["exports","jquery","core/modal_factory","core/modal_events"],(function(_exports,_jquery,_modal_factory,_modal_events){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   *  Sharing Cart
   *
   *  @package    block_sharing_cart
   *  @copyright  2017 (C) VERSION2, INC.
   *  @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_jquery=_interopRequireDefault(_jquery),_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events);_exports.init=function(addMethod){(0,_jquery.default)(document).ready((function(){let isDragging=!1;function str(identifier){return M.str.block_sharing_cart[identifier]||M.str.moodle[identifier]}function get_action_url(name,args){let url=M.cfg.wwwroot+"/blocks/sharing_cart/"+name+".php";if(args){const q=[];for(let k in args)q.push(k+"="+encodeURIComponent(args[k]));url+="?"+q.join("&")}return url}function remove_basket(){if("drag_and_drop"===addMethod&&!isDragging){const footerIconContainer=document.getElementById("page-footer").querySelector('div[data-region="footer-container-popover"]'),sharingCartBasket=document.querySelector("button.sharing_cart_basket");sharingCartBasket&&(null==footerIconContainer||footerIconContainer.removeChild(sharingCartBasket),sharingCartBasket.classList.remove("shake_basket"))}}function confirm_modal(obj){obj.checkbox&&(obj.body+='<div class="modal-checbox-wrapper modal-sharing_cart"><div class="form-check"><input type="checkbox" id="modal-userdata-checkbox" class="form-check-input"><label for="modal-userdata-checkbox" class="form-check-label">'+str("modal_checkbox")+'</label></div><div class="form-check"><input type="checkbox" id="modal-anonymize-checkbox" class="form-check-input" disabled><label for="modal-anonymize-checkbox" class="form-check-label">'+str("modal_checkbox_anonymize")+"</label></div></div>"),_modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:obj.title,body:obj.body}).done((function(modal){let is_submitted=!1;modal.setSaveButtonText(obj.save_button);const userdata_checkbox=(0,_jquery.default)(modal.getRoot()).find("#modal-userdata-checkbox"),anonymize_checkbox=(0,_jquery.default)(modal.getRoot()).find("#modal-anonymize-checkbox");userdata_checkbox.on("change",(e=>{e.currentTarget.checked?anonymize_checkbox.attr("disabled",null):anonymize_checkbox.prop("checked",!1).attr("disabled",!0)})),modal.getRoot().on(_modal_events.default.save,(function(e){const response={userdata:userdata_checkbox.is(":checked"),anonymize:anonymize_checkbox.is(":checked")};obj.next(response),is_submitted=!0})),modal.getRoot().on(_modal_events.default.cancel,(function(){remove_basket()})),modal.getRoot().on(_modal_events.default.hidden,(function(){(0,_jquery.default)("body").removeClass("modal-open"),is_submitted||remove_basket()})),modal.show()}))}function in_place_edit_section_name($section){let sectionName="";const $inPlaceEditable=$section.find("h3.sectionname .inplaceeditable");return $inPlaceEditable.length&&(sectionName=$inPlaceEditable.data("value")),sectionName}function on_backup_modal(post_data,title_str,body_str,isSection){_jquery.default.post(get_action_url("rest"),post_data,(function(response){!function(response){let checkbox=!1;"1"===response&&(checkbox=!0),confirm_modal({title:title_str,body:body_str,save_button:str("modal_confirm_backup"),checkbox:checkbox,next:function(data){!0===isSection?function(sectionId,sectionNumber,courseId,userdata,anonymize){const $commands=(0,_jquery.default)("span.inplaceeditable[data-itemtype=sectionname][data-itemid="+sectionId+"]"),$section=$commands.closest("li.section.main");let sectionName=$section.attr("aria-label")||$section.find(".sectionname").text().trim();null===sectionName&&(sectionName=String((0,_jquery.default)("#region-main .section_action_menu[data-sectionid='"+sectionId+"']").parent().parent().find("h3.sectionname").text()));const inPlaceEditSectionName=in_place_edit_section_name($section);sectionName=""!==inPlaceEditSectionName?inPlaceEditSectionName:sectionName;const $spinner=add_spinner(),$node_spinner=add_node_spinner($commands);_jquery.default.post(get_action_url("rest"),{action:"backup_section",sectionid:sectionId,sectionnumber:sectionNumber,courseid:courseId,sectionname:sectionName,userdata:userdata,anonymize:anonymize,sesskey:M.cfg.sesskey},(function(){reload_tree()})).fail((function(response){show_error(response)})).always((function(){$spinner.hide(),$node_spinner.hide(),remove_basket()}))}(post_data.sectionid,post_data.sectionnumber,post_data.courseid,data.userdata,data.anonymize):function(cmid,userdata,anonymize){let $commands=(0,_jquery.default)("#module-"+cmid+" .actions");$commands.length||($commands=(0,_jquery.default)('[data-owner="#module-'+cmid+'"]'));const $spinner=add_spinner(),$node_spinner=add_node_spinner($commands);_jquery.default.post(get_action_url("rest"),{action:"backup",cmid:cmid,userdata:userdata,anonymize:anonymize,sesskey:M.cfg.sesskey,courseid:course.id},(function(){reload_tree()})).fail((function(response){show_error(response)})).always((function(){$node_spinner.hide(),$spinner.hide(),remove_basket()}))}(post_data.cmid,data.userdata,data.anonymize),function(){if("drag_and_drop"===addMethod){const sharingCartBasket=document.querySelector("button.sharing_cart_basket");null==sharingCartBasket||sharingCartBasket.classList.add("shake_basket")}}()}})}(response)}),"text").fail((function(response){show_error(response)}))}const icon={backup:{css:"editing_backup",iconClass:"fa fa-frown-o"},movedir:{css:"editing_right",iconClass:"fa fa-arrow-right"},move:{css:"editing_move_",iconClass:"fa fa-arrows-v"},edit:{css:"editing_update",iconClass:"fa fa-pencil"},cancel:{css:"editing_cancel",iconClass:"fa fa-ban"},delete:{css:"editing_update",iconClass:"fa fa-trash"},restore:{css:"editing_restore",iconClass:"fa fa-clone"},"dir-open":{iconClass:"fa fa-folder-open-o"},"dir-closed":{iconClass:"fa fa-folder-o"}},$block=(0,_jquery.default)(".block_sharing_cart"),course=new function(){const body=(0,_jquery.default)("body");this.id=body.attr("class").match(/course-(\d+)/)[1],this.is_frontpage=body.hasClass("pagelayout-frontpage")};function show_error(response){try{const ex=JSON.parse(response.responseText);new M.core.exception({name:str("pluginname")+" - "+str("error"),message:ex.message})}catch(e){new M.core.exception({name:str("pluginname")+" - "+str("error"),message:response.responseText})}}function create_command(name){const iconElement=(0,_jquery.default)("<i/>").attr("alt",str(name)).attr("class",icon[name].iconClass);return(0,_jquery.default)('<a href="javascript:void(0)"/>').addClass(icon[name].css).attr("title",str(name)).append(iconElement)}function add_spinner(){const $spinner=(0,_jquery.default)('<div class="block_spinner"><i class="fa fa-shopping-basket sharing_cart_basket shake_basket fa-2x"></i></div>');return(0,_jquery.default)("section.block_sharing_cart").append($spinner),$spinner}function add_node_spinner($node){const $node_spinner=(0,_jquery.default)('<i class="fa fa-circle-o-notch fa-spin node_spinner node_spinner-sharing_cart"></i>');return $node.append($node_spinner),$node_spinner}function reload_tree(){_jquery.default.post(get_action_url("rest"),{action:"render_tree",courseid:course.id},(function(response){$block.find(".tree").replaceWith((0,_jquery.default)(response)),_jquery.default.init_item_tree()}),"html").fail((function(response){show_error(response)}))}(0,_jquery.default)(document).on("click","a.restore",(function(){add_spinner()}));const directories=new function(){const KEY="block_sharing_cart-dirs";let opens=function(param){const readCookie=document.cookie.match("(^|;)\\s*"+param+"\\s*=\\s*([^;]+)");return readCookie?readCookie.pop():""}(KEY).split(",").map((function(v){return parseInt(v)}));function save(){const expires=new Date;expires.setDate(expires.getDate()+30),function(name,value,expireTimeInMillisecond){const d=new Date;d.setTime(d.getTime()+expireTimeInMillisecond);const expires="expires="+d.toUTCString();document.cookie=name+"="+value+";"+expires}(KEY,opens.join(","),expires)}function open($dir,visible){const iconElement=icon[visible?"dir-open":"dir-closed"].iconClass;$dir.find("> div i.icon").attr("class","icon "+iconElement),$dir.find("> ul.list")[visible?"show":"hide"]()}this.init=function(){let i=0;$block.find("li.directory").each((function(index,dir){const $dir=(0,_jquery.default)(dir);$dir.attr("id","block_sharing_cart-dir-"+i),i>=opens.length?opens.push(0):opens[i]&&open($dir,!0),$dir.find("> div div.toggle-wrapper").css("cursor","pointer").on("click",(function(e){!function(e){const $dir=(0,_jquery.default)(e.target).closest("li.directory"),i=$dir.attr("id").match(/(\d+)$/)[1],v="none"===$dir.find("> ul.list").css("display");open($dir,v),opens[i]=v?1:0,save()}(e)})),i++}))},this.reset=function(){opens=[],this.init(),save()}},move_targets=new function(){let $cancel=null,targets=[];this.hide=function(){if(null!==$cancel){const $commands=$cancel.closest(".commands");$cancel.remove(),$cancel=null,$commands.closest("li.activity").css("opacity",1),$commands.find("a").each((function(){(0,_jquery.default)(this).show()})),_jquery.default.each(targets,(function(index,$target){$target.remove()})),targets=[]}},this.show=function(item_id){this.hide();const $current=$block.find("#block_sharing_cart-item-"+item_id),$next=$current.next(),$list=$current.closest("ul");let next_id=0;function create_target(item_id,area_to){const $anchor=(0,_jquery.default)('<a href="javascript:void(0)"/>').addClass("move-"+item_id+"-to-"+area_to).attr("title",str("movehere")).append((0,_jquery.default)("<p>"+str("clicktomove")+"</p>").attr("alt",str("movehere"))),$target=(0,_jquery.default)('<li class="activity move-to"/>').append($anchor);return $anchor.on("click",(function(e){!function(e){const m=(0,_jquery.default)(e.target).closest("a").attr("class").match(/move-(\d+)-to-(\d+)/),item_id=m[1],area_to=m[2],$spinner=add_spinner();_jquery.default.post(get_action_url("rest"),{action:"move",item_id:item_id,area_to:area_to,sesskey:M.cfg.sesskey},(function(){reload_tree()})).fail((function(response){show_error(response)})).always((function(){$spinner.hide()}))}(e)})),$target}if($next.length&&(next_id=$next.attr("id").match(/item-(\d+)$/)[1]),$list.find("> li.activity").each((function(index,item){const $item=(0,_jquery.default)(item),to=$item.attr("id").match(/item-(\d+)$/)[1];if(to===item_id){$cancel=create_command("cancel"),$cancel.on("click",(function(){move_targets.hide()}));const $commands=$item.find(".commands");$commands.find("a").each((function(){(0,_jquery.default)(this).hide()})),$commands.append($cancel),$item.css("opacity",.5)}else if(to!==next_id){const $target=create_target(item_id,to);$item.before($target),targets.push($target)}}),this),$next){var $target=create_target(item_id,0);$list.append($target),targets.push($target)}}},restore_targets=new function(){this.is_directory=null;let $clipboard=null,targets=[];function create_target(id,section){const href=get_action_url("restore",{directory:!0===restore_targets.is_directory,target:id,course:course.id,section:section,in_section:(0,_jquery.default)("#copy-section-form").data("in-section"),sesskey:M.cfg.sesskey,returnurl:document.URL});let $target=(0,_jquery.default)("<a/>").attr("href",href).attr("title",str("copyhere")).append((0,_jquery.default)('<img class="move_target"/>').attr("alt",str("copyhere")).attr("src",M.util.image_url("dropzone_arrow","block_sharing_cart")));return targets.push($target),$target}this.hide=function(){null!==$clipboard&&($clipboard.remove(),$clipboard=null,_jquery.default.each(targets,(function(index,$target){$target.remove()})),targets=[])},this.show=function(id){this.hide();let $view=(0,_jquery.default)("<span/>");if(this.is_directory)$view.html(id).css("display","inline"),$view.prepend((0,_jquery.default)("<i/>").addClass("icon").attr("alt",id));else{const $item=$block.find("#block_sharing_cart-item-"+id);$view=(0,_jquery.default)($item.find("div")[0].cloneNode(!0)).css("display","inline"),$view.attr("class",$view.attr("class").replace(/mod-indent-\d+/,"")),$view.find(".commands").remove()}const $cancel=create_command("cancel");if($cancel.on("click",this.hide),$clipboard=(0,_jquery.default)('<div class="clipboard"/>'),$clipboard.append(str("clipboard")+": ").append($view).append($cancel),course.is_frontpage){const $sitetopic=(0,_jquery.default)(".sitetopic"),$mainmenu=(0,_jquery.default)(".block_site_main_menu");$sitetopic?$sitetopic.find("*").before($clipboard):$mainmenu&&$mainmenu.find(".content").before($clipboard),$mainmenu&&$mainmenu.find(".footer").before(create_target(id,0)),$sitetopic&&$sitetopic.find("ul.section").append(create_target(id,1))}else{const $container=(0,_jquery.default)(".course-content");$container.prepend($clipboard),$container.find('[data-for="section"]').each((function(index,sectionDOM){const $section=(0,_jquery.default)(sectionDOM),section=$section.attr("id").match(/(\d+)$/)[1];$section.find("ul.section").first().append(create_target(id,section))}),this)}}};function init_footer_basket(){let currentDragging;const activities=document.querySelectorAll(".activity.activity-wrapper"),sections=document.querySelectorAll(".course-section-header"),sharingCartBlock=document.querySelector('section[data-block="sharing_cart"]');!function(){var _document$getElements;const courseSectionHeader=null!==(_document$getElements=document.getElementsByClassName("course-section-header")[0])&&void 0!==_document$getElements?_document$getElements:null;courseSectionHeader instanceof HTMLElement&&(courseSectionHeader.classList.add("draggable"),courseSectionHeader.setAttribute("draggable",!0))}();const footerIconContainer=document.getElementById("page-footer").querySelector('div[data-region="footer-container-popover"]'),basket=document.createElement("i");basket.setAttribute("class","fa fa-shopping-basket");const basketButton=document.createElement("button");basketButton.setAttribute("class","btn btn-icon bg-secondary icon-no-margin btn-footer-popover sharing_cart_basket"),basketButton.setAttribute("style","z-index: 1001;"),basketButton.append(basket);const dropAreaText=document.createElement("p");dropAreaText.setAttribute("class","font-weight-bold text-white"),dropAreaText.innerText=str("drop_here");const dropArea=document.createElement("div");function drag_event_listeners(draggable){draggable.addEventListener("dragstart",(e=>{basketButton.classList.remove("shake_basket"),null==footerIconContainer||footerIconContainer.prepend(basketButton),sharingCartBlock.children[0].classList.add("dragging_item"),sharingCartBlock.append(dropArea),currentDragging=e.target,isDragging=!0})),draggable.addEventListener("dragend",(()=>{currentDragging instanceof HTMLElement&&(null==footerIconContainer||footerIconContainer.removeChild(basketButton)),sharingCartBlock.children[0].classList.remove("dragging_item"),sharingCartBlock.removeChild(dropArea),isDragging=!1}))}dropArea.setAttribute("class","h-100 w-100 position-absolute d-flex justify-content-center align-items-center"),dropArea.append(dropAreaText),sections.forEach((section=>{drag_event_listeners(section)})),activities.forEach((activity=>{drag_event_listeners(activity)})),[basketButton,sharingCartBlock].forEach((dropzone=>{dropzone.addEventListener("dragover",(e=>{e.preventDefault(),dropzone.classList.add("drag_over")})),dropzone.addEventListener("dragenter",(e=>{e.preventDefault(),dropzone.classList.add("drag_over")})),dropzone.addEventListener("dragleave",(()=>{dropzone.classList.remove("drag_over")})),dropzone.addEventListener("drop",(()=>{currentDragging instanceof HTMLElement&&currentDragging.querySelector(".add-to-sharing-cart").click(),dropzone.classList.remove("drag_over"),currentDragging=void 0,isDragging=!1}))}))}_jquery.default.get_plugin_name=function(){let $blockheader=$block.find("h2");return $blockheader.length?$blockheader.html():($blockheader=$block.find("h3"),$blockheader.length?$blockheader.html():"")},_jquery.default.on_backup=function(e,activityName){let cmId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:0;0===cmId&&(cmId=function($backup){const $activity=$backup.closest("li.activity");if($activity.length)return $activity.attr("id").match(/(\d+)$/)[1];const $commands=$backup.closest(".commands"),dataowner=$commands.attr("data-owner");return dataowner.length?dataowner.match(/(\d+)$/)[1]:$commands.find("a.editing_delete").attr("href").match(/delete=(\d+)/)[1]}((0,_jquery.default)(e.target)));const data={action:"is_userdata_copyable",cmid:cmId};on_backup_modal(data,activityName,str("confirm_backup"),!1)},_jquery.default.on_movedir=function(e){const $commands=(0,_jquery.default)(e.target).closest(".commands"),$current_dir=$commands.closest("li.directory"),current_path=$current_dir.length?$current_dir.attr("directory-path"):"/",item_id=(0,_jquery.default)(e.target).closest("li.activity").attr("id").match(/(\d+)$/)[1],dirs=[];$block.find("li.directory").each((function(){dirs.push((0,_jquery.default)(this).attr("directory-path"))}));const $form=(0,_jquery.default)("<form/>");function submit(){const folder_to=$form.find('[name="to"]').val(),$spinner=add_spinner();_jquery.default.post(get_action_url("rest"),{action:"movedir",item_id:item_id,folder_to:folder_to,sesskey:M.cfg.sesskey},(function(){reload_tree(),directories.reset()})).fail((function(response){show_error(response)})).always((function(){$spinner.hide()}))}if($form.attr("action","javascript:void(0)"),$form.submit(submit),0===dirs.length){var $input=(0,_jquery.default)('<input class="form-control" type="text" name="to"/>').val(current_path);setTimeout((function(){$input.focus()}),1),$form.append($input)}else{dirs.unshift("/");const $select=(0,_jquery.default)('<select class="custom-select" name="to"/>');for(let i=0;i<dirs.length;i++)$select.append((0,_jquery.default)("<option/>").val(dirs[i]).append(dirs[i]));$select.val(current_path),$select.change(submit),$form.append($select);const $edit=create_command("edit");$edit.on("click",(function(){const $input=(0,_jquery.default)('<input type="text" name="to"/>').val(current_path);$select.remove(),$edit.replaceWith($input),$input.focus()})),$form.append($edit)}const $cancel=create_command("cancel");$cancel.on("click",(function(){$form.remove(),$commands.find("a").show()})),$form.append($cancel),$commands.find("a").each((function(){(0,_jquery.default)(this).hide()})),$commands.append($form)},_jquery.default.on_move=function(e){const id=(0,_jquery.default)(e.target).closest("li.activity").attr("id").match(/(\d+)$/)[1];move_targets.show(id)},_jquery.default.on_delete=function(e){const $item=(0,_jquery.default)(e.target).closest("li"),liText=$item[0].innerText;let modalBody,item,isDirectory=!1,description_text="";$item.hasClass("directory")?(isDirectory=!0,item=str("folder_string"),description_text=str("delete_folder")):item=str("activity_string"),modalBody='<p class="delete-item">'+item+" "+liText+description_text+"</p>",confirm_modal({title:str("confirm_delete"),body:modalBody,save_button:str("modal_confirm_delete"),checkbox:!1,next:function(){let data={};!0===isDirectory?data={action:"delete_directory",path:$item.attr("directory-path"),sesskey:M.cfg.sesskey}:$item.hasClass("activity")&&(data={action:"delete",id:$item.attr("id").match(/(\d+)$/)[1],sesskey:M.cfg.sesskey});const $spinner=add_spinner();_jquery.default.post(get_action_url("rest"),data,(function(){reload_tree()})).fail((function(response){show_error(response)})).always((function(){$spinner.hide()})),e.stopPropagation()}})},_jquery.default.on_restore=function(e){const $item=(0,_jquery.default)(e.target).closest("li");let id=null;$item.hasClass("directory")?(id=$item.attr("directory-path"),restore_targets.is_directory=!0):$item.hasClass("activity")&&(id=$item.attr("id").match(/(\d+)$/)[1],restore_targets.is_directory=!1),restore_targets.show(id)},_jquery.default.on_section_backup=function(sectionId,sectionNumber,courseId,sectionName){on_backup_modal({action:"is_userdata_copyable_section",sectionid:sectionId,sectionnumber:sectionNumber,courseid:courseId},sectionName,'<p class="alert alert-danger mt-3">'+str("backup_heavy_load_warning_message")+"</p>"+str("confirm_backup_section"),!0)},_jquery.default.init_bulk_delete=function(isspeciallayout){const bulkdelete=$block.find(".editing_bulkdelete");bulkdelete.length&&(isspeciallayout?(bulkdelete.attr("role","menuitem").addClass("dropdown-item menu-action"),bulkdelete.append((0,_jquery.default)("<span class='menu-action-text'/>").append(bulkdelete.attr("title"))),$block.find(".menubar .dropdown .dropdown-menu").append(bulkdelete)):$block.find(".header .commands").append(bulkdelete))},_jquery.default.init_help_icon=function(isspeciallayout){const helpicon=$block.find(".header-commands > .help-icon");isspeciallayout?$block.find(".header-commands").parent().css("display","block"):$block.find(".header .commands").append(helpicon)},_jquery.default.init_block_header=function(){const isspeciallayout=$block.find(".menubar .dropdown .dropdown-menu").length;_jquery.default.init_bulk_delete(isspeciallayout),_jquery.default.init_help_icon(isspeciallayout)},_jquery.default.init_item_tree=function(){function add_actions(item,actions){const $item=(0,_jquery.default)(item),isCopying="1"===$item.attr("data-is-copying"),$commands=$item.find(".commands").first();_jquery.default.each(actions,(function(index,action){if("restore"===action&&isCopying)return;const $command=create_command(action);$command.on("click",(function(e){_jquery.default["on_"+action](e)})),$commands.append($command)}),this)}const activity_actions=["movedir","move","delete"];course&&activity_actions.push("restore");const directory_actions=["delete","restore"];$block.find("li.activity").each((function(index,item){1!=(0,_jquery.default)(item).attr("data-disable-copy")?add_actions(item,activity_actions):add_actions(item,["movedir","move","delete"])})),$block.find("li.directory").each((function(index,item){add_actions(item,directory_actions)})),directories.init()},_jquery.default.init_activity_commands=function(){function create_backup_icon(){const $backupIcon=(0,_jquery.default)('<a href="javascript:void(0)" class="add-to-sharing-cart" />').append((0,_jquery.default)('<i class="fa fa-shopping-basket icon"></i>')).attr("title",str("backup"));return"click_to_add"!==addMethod&&$backupIcon.addClass("d-none"),$backupIcon}function add_activity_backup_control($activity){const activityClass=$activity[0].className,modtype=activityClass.substr(activityClass.indexOf("modtype_")+8);let activityName=str("activity_string");"label"!==modtype&&(activityName=(0,_jquery.default)(".activity#"+$activity[0].id).find(".mod-indent-outer .activityinstance span.instancename").html());const $backupIcon=create_backup_icon();$backupIcon.on("click",(function(e){_jquery.default.on_backup(e,activityName)}));const $actionMenuItem=$activity.find(".action-menu.section-cm-edit-actions").parent(".actions");$actionMenuItem.find(".add-to-sharing-cart").length||$actionMenuItem.append($backupIcon)}(0,_jquery.default)(document).ajaxComplete((function(event,xhr,settings){const url=settings.url,lastslashindex=url.lastIndexOf("="),result=url.substring(lastslashindex+1);if("core_course_edit_module"===result||"core_course_get_module"===result){const data=JSON.parse(settings.data),action=data[0].args.action;if("delete"===action)return;setTimeout((function(){const activity_id=data[0].args.id,activity=(0,_jquery.default)("#module-"+activity_id);if(add_activity_backup_control(activity),"duplicate"===action){add_activity_backup_control(activity.next())}}),1)}})),(0,_jquery.default)("body.editing .course-content li.section").each((function(){!function($section){let sectionId=$section.find(".section_action_menu").data("sectionid");const sectionNumber=parseInt(String($section.attr("id")).match(/\d+/)[0]);let sectionName=$section.attr("aria-label")||$section.find(".sectionname").text().trim();const isFlexibleCourseFormat=(0,_jquery.default)("body[id$=flexsections]").length;isFlexibleCourseFormat&&null==sectionId&&(sectionId=$section.data("section-id"));const courseId=parseInt(String((0,_jquery.default)("body").attr("class")).match(/course-([0-9]*)( |$)/)[1]),$backupIcon=create_backup_icon();$backupIcon.on("click",(function(){const inPlaceEditSectionName=in_place_edit_section_name($section);sectionName=""!==inPlaceEditSectionName?inPlaceEditSectionName:sectionName,_jquery.default.on_section_backup(sectionId,sectionNumber,courseId,sectionName)}));let $sectionTitle=$section.find("h3.sectionname").first().find("a").last();const $inPlaceEditable=$section.find("h3.sectionname .inplaceeditable").first();$inPlaceEditable.length&&($sectionTitle=$inPlaceEditable),isFlexibleCourseFormat&&0===sectionNumber?($sectionTitle=$section.find("> .controls"),$sectionTitle.prepend($backupIcon)):$backupIcon.insertAfter($sectionTitle);const $activities=$section.find("li.activity");(0,_jquery.default)($activities).each((function(){add_activity_backup_control((0,_jquery.default)(this))}))}((0,_jquery.default)(this))}))},_jquery.default.init=function(){M.str.block_sharing_cart.pluginname=this.get_plugin_name(),_jquery.default.init_block_header(),_jquery.default.init_item_tree(),_jquery.default.init_activity_commands(),"drag_and_drop"===addMethod&&init_footer_basket()};var $spinner=(0,_jquery.default)("<i/>").addClass("spinner fa fa-3x fa-circle-o-notch fa-spin");(0,_jquery.default)("div#sharing-cart-spinner-modal div.spinner-container").prepend($spinner),_jquery.default.init()})),(0,_jquery.default)(".copy_section").on("click",(function(){const $section_selected=(0,_jquery.default)(".section-dropdown option:selected"),sectionId=$section_selected.data("section-id"),sectionNumber=$section_selected.data("section-number"),courseId=$section_selected.data("course-id"),sectionName=$section_selected.data("section-name");_jquery.default.on_section_backup(sectionId,sectionNumber,courseId,sectionName)})),(0,_jquery.default)(".copy_activity").on("click",(function(e){const activitySelected=(0,_jquery.default)(".activity-dropdown option:selected"),activityId=activitySelected.data("activity-id"),activityName=activitySelected.data("activity-name");_jquery.default.on_backup(e,activityName,activityId)}))}}));

//# sourceMappingURL=script.min.js.map